#include "hdf.h"
#include "mfhdf.h"

	/* Arrays containing dimension info for datasets. */
	static int32  d_dims[3]     = {2, 3, 4};  /* Data dimensions */
	static int32  edge_dims[3]  = {0, 0, 0};  /* Edge dims */
	static int32  start_dims[3] = {0, 0, 0};  /* Starting dims  */
	static int32  cdims[3]      = {1, 2, 3};  /* Chunk lengths */

static uint16  u16_3data[2][3][4] =
{
    {
        { 0, 1, 2, 3},
        { 10, 11, 12, 13},
        { 20, 21, 22, 23}},
    {
        { 100, 101, 102, 103},
        { 110, 111, 112, 113},
        { 120, 121, 122, 123}}};

main( ) 
{

	int32 f1;	/* File handle */
	int32 sdsid;	/* SDS handle */
	uint16  ru16_3data[4];       /* Whole chunk input buffer */
	int32   rcdims[3];           /* For SDgetchunkinfo() */
	uint16  fill_u16 = 0;        /* Fill value */
	int32 c_flags;
	HDF_CHUNK_DEF c_def, r_def; 

    int32 status;

    /* Create the HDF file. */
	f1 = SDstart("Example15.hdf", DFACC_CREATE);

/* Create a new 2x3x4 SDS of uint16 in the file. */
	d_dims[0] = 2;
	d_dims[1] = 3;
	d_dims[2] = 4;
	sdsid = SDcreate(f1, "DataSetChunked_4", DFNT_UINT16, 3, d_dims);

	/* Set the fill value. */
	fill_u16 = 0;
	status = SDsetfillvalue(sdsid, (VOIDP) &fill_u16);

	/* Create chunked SDS - chunk is 1x1x4 which will create 6 chunks. */
	c_def.chunk_lengths[0] = 1;
	c_def.chunk_lengths[1] = 1;
	c_def.chunk_lengths[2] = 4;
	status = SDsetchunk(sdsid, c_def, HDF_CHUNK);

	/* Set chunk cache to hold a maximum of 4 chunks. */
	status = SDsetchunkcache(sdsid, 4, 0);

	/* Write data using SDwritedata. */
	start_dims[0] = 0;
	start_dims[1] = 0;
	start_dims[2] = 0;
	edge_dims[0] = 2;
	edge_dims[1] = 3;
	edge_dims[2] = 4;
	status = SDwritedata(sdsid, start_dims, NULL, edge_dims, \
						(VOIDP) u16_3data);

	/* Read data using SDreadchunk and verify against
       the chunk arrays chunk1_3u16[] ... chunk6_3u16[]. */

	/* Read chunk 1. */
	start_dims[0] = 0;
	start_dims[1] = 0;
	start_dims[2] = 0;
	status = SDreadchunk(sdsid, start_dims, (VOIDP) ru16_3data);

	/* Read chunk 2. */
	start_dims[0] = 0;
	start_dims[1] = 1;
	start_dims[2] = 0;
	status = SDreadchunk(sdsid, start_dims, (VOIDP) ru16_3data);

	/* Read chunk 3. */
	start_dims[0] = 0;
	start_dims[1] = 2;
	start_dims[2] = 0;
	status = SDreadchunk(sdsid, start_dims, (VOIDP) ru16_3data);

	/* Read chunk 4. */
	start_dims[0] = 1;
	start_dims[1] = 0;
	start_dims[2] = 0;
	status = SDreadchunk(sdsid, start_dims, (VOIDP) ru16_3data);

	/* Read chunk 5. */
	start_dims[0] = 1;
	start_dims[1] = 1;
	start_dims[2] = 0;
	status = SDreadchunk(sdsid, start_dims, (VOIDP) ru16_3data);

	/* Read chunk 6. */
	start_dims[0] = 1;
	start_dims[1] = 2;
	start_dims[2] = 0;
	status = SDreadchunk(sdsid, start_dims, (VOIDP) ru16_3data);

	/* Get chunk lengths. */
	status = SDgetchunkinfo(sdsid, &r_def, &c_flags);

	/* Close the current SDS. */    
	status = SDendaccess(sdsid);

	/* Close down the SDS interface. */
	status = SDend(f1);

}
