#include "hdf.h"
#include "mfhdf.h"

#define X_LENGTH 4
#define Y_LENGTH 5
#define Z_LENGTH 6

main( ) 
{

	int32 sd_id, sds_index, sds_id, status;
	int32 start[3], edges[3]; 
	int16 array_data[Z_LENGTH][Y_LENGTH][X_LENGTH];

	/* Open the file. */
	sd_id = SDstart("Example4.hdf", DFACC_RDONLY);

	/* Search for the index of a non-existent array data set. */
	sds_index = SDnametoindex(sd_id, "Invalid_Data_Set_Name");

	/* Error condition: sds_index contains the value -1. */

	/* Search for the index of a "Ex_array_4" array data set. */
	sds_index = SDnametoindex(sd_id, "Ex_array_4");

    /* Select the data set corresponding to the returned index. */
    sds_id = SDselect(sd_id, sds_index);

    /* Read the data set data into the array_data array. */
	start[0] = start[1] = start[2] = 0;
	edges[0] = Z_LENGTH;
	edges[1] = Y_LENGTH;
	edges[2] = X_LENGTH;

	status = SDreaddata(sds_id, start, NULL, edges, (VOIDP)array_data);

	/* Terminate access to the array */
    status = SDendaccess(sds_id);

    /* Terminate access to the SD interface and close the file */
    status = SDend(sd_id);

}

