#include "hdf.h"
#include "mfhdf.h"

#include <stdio.h>

main( ) 
{

	int32 sd_id, sds_id, n_datasets, n_file_attrs, index, status;
	int32 dim_sizes[MAX_VAR_DIMS];
	int32 rank, num_type, attributes;
	char name[MAX_NC_NAME];

	/* Open the file and initiate the SD interface. */
	sd_id = SDstart("Example4.hdf", DFACC_RDONLY);

	/* Determine the contents of the file. */
	status = SDfileinfo(sd_id, &n_datasets, &n_file_attrs);

	/* Access and print the name of every data set in the file. */
	for (index = 0; index < n_datasets; index++) {
		sds_id = SDselect(sd_id, index);
		status = SDgetinfo(sds_id, name, &rank, dim_sizes, \
					&num_type, &attributes);

		printf("name = %s\n", name);
		status = SDendaccess(sds_id);
	}

    /* Terminate access to the SD interface and close the file. */
    status = SDend(sd_id);

}

