      PROGRAM SET ATTRIBS

      real*8 data(5, 2, 3), max, min, i, j, k
      integer*4 dimsizes(3)
      integer status, rank

      integer dsslens, dssdast, dssrang, dsadata
      integer dssdims

      character*13 label /"Pressure Data"/
      character*9 unit /"Millibars"/
      character*4 format /"F5.5"/
      character*4 coordsys /"None"/

C     Set the dimensions, to define the beginning of a data set.
      rank = 3
      dimsizes(1) = 5
      dimsizes(2) = 2
      dimsizes(3) = 3
      status = dssdims(rank, dimsizes)

C     Set the maximum string lengths to 50.
      status = dsslens(50, 50, 50, 50)

C     Define the attribute strings and values.
      status = dssdast(label, unit, format, coordsys)
      max = 1500.0
      min = 0.0
      status = dssrang(max, min)

C     Fill the data array with values.
      do 30 k = 1, 3
       do 20 j = 1, 2
        do 10 i = 1, 5
          data(i, j, k) = i*100.0 + j*10.0 + k
10      continue
20     continue
30    continue

C     Write the data set and its attributes to file.
      status = dsadata("Example3.hdf", rank, dimsizes, data)

      end
