#include "hdf.h"
		
/*  
 *  Write an array of floating point values representing
 *  pressure in a 3x2x5 array.
 */

main( ) 
{

	float32 data[3][2][5];
	int32 dimsizes[3];
	float32 max, min;
	intn status, rank;
	int i, j, k; 

	/* Set the rank and dimension sizes. */
	rank = 3;
	dimsizes[0] = 3;
	dimsizes[1] = 2;
	dimsizes[2] = 5;

	/* Set the dimensions, to define the beginning of a data set. */
	status = DFSDsetdims(rank, dimsizes);

	/* Set the maximum string length to 50. */
	status = DFSDsetlengths(50, 50, 50, 50);

	/* Define the attribute strings and values. */
	status = DFSDsetdatastrs("Pressure Data", "Millibars", "F5.5", "None");
	max = 1500.0;
	min = 0.0;
	status = DFSDsetrange(&max, &min);

	/* Set the rank to 3. */
	rank = 3;

	/* Calculate the data values. */
	for (i = 0; i < 3; i++)
		for (j = 0; j < 2; j++)
			for (k = 0; k < 5; k++)
				data[i][j][k] = i*100.0 + j*10.0 + k;
   
	/* Write the data set and its attributes to file. */
	status = DFSDadddata("Example3.hdf", rank, dimsizes, data);

}
