#include "hdf.h"

main( ) 
{
	int32 gr_id, ri_id, file_id, n_datasets, n_file_attrs, gr_index;
	int32 dim_sizes[2];
	int32 ncomp, il, data_type, attributes, status;
	char name[MAX_GR_NAME];

	/* Open the file. */
	file_id = Hopen("Example2.hdf", DFACC_RDONLY, 0);

	/* Initiate the GR interface. */
	gr_id = GRstart(file_id);

	/* Determine the contents of the file. */
	status = GRfileinfo(gr_id, &n_datasets, &n_file_attrs);

	/* Access and print the name of each image in the file. */
	for (gr_index = 0; gr_index < n_datasets; gr_index++) {
		ri_id = GRselect(gr_id, gr_index);
		status = GRgetiminfo(ri_id, name, &ncomp, &data_type, \
        					&il, dim_sizes, &attributes);
		printf("name = %s\n", name);
		status = GRendaccess(ri_id);
	}

    /* Terminate access to the GR interface. */
    status = GRend(gr_id);

    /* Close the file. */
    status = Hclose(file_id);

}
