      PROGRAM READ ARRAY

      integer*4 gr_id, ri_id, file_id, status
      integer start(2), edge(2), stride(2)
      integer hopen, hclose, mgstart, mgselct, mgrdimg
      integer mgendac, mgend

C     DFACC_RDONLY is defined in hdf.h. MAX_NC_NAME and MAX_VAR_DIMS
C     are defined in netcdf.h.
      integer*4 DFACC_RDONLY, MAX_NC_NAME, MAX_VAR_DIMS
      integer*4 X_LENGTH, Y_LENGTH
      parameter (DFACC_RDONLY = 1, MAX_NC_NAME = 256, 
     +           MAX_VAR_DIMS = 32, X_LENGTH = 15, 
     +           Y_LENGTH = 10)
      integer*2 array_data(2, X_LENGTH, Y_LENGTH)
      integer dims(MAX_VAR_DIMS)

C     Open the file.
      file_id = hopen('Example2.hdf', DFACC_RDONLY, 0)

C     Initiate the GR interface.
      gr_id = mgstart(file_id)

C     Select the first (and in this case, only) data set in the file.
      ri_id = mgselct(gr_id, 0)

C     Define the location, pattern, and size of the data to read
C     from the data set.
      dims(1) = X_LENGTH
      dims(2) = Y_LENGTH
      start(1) = 0
      start(2) = 0
      stride(1) = 1
      stride(2) = 1
      edge(1) = dims(1)
      edge(2) = dims(2)

C     Read the array data set.
      status = mgrdimg(ri_id, start, stride, edge, array_data)

C     Terminate access to the image array.
      status = mgendac(ri_id)

C     Terminate access to the GR interface and the file.
      status = mgend(gr_id)

C     Close the file.
      status = hclose(file_id)

      end
