#include "hdf.h"
#include "mfgr.h"

#define X_LENGTH 5
#define Y_LENGTH 10

main( ) 
{

	int32 gr_id, ri_id, file_id, status;
	int32 dimsizes[2], ncomp, il;

	/* Create and open the file. */
	file_id = Hopen("Example1.hdf", DFACC_CREATE, 0);

	/* Initiate the GR interface. */
	gr_id = GRstart(file_id);

	/* Define the number of components and dimensions of the image. */
	ncomp = 2;
	il = MFGR_INTERLACE_PIXEL;
	dimsizes[0] = X_LENGTH;
	dimsizes[1] = Y_LENGTH;

	/* Create the image array. */
	ri_id = GRcreate(gr_id, "Image_array_1", ncomp, DFNT_INT16, il, 
					dimsizes);

	/* Terminate access to the image array. */
	status = GRendaccess(gr_id);

	/* Terminate access to the GR interface and close the file */
	status = GRend(ri_id);

	/* Close the file. */
	status = Hclose(file_id);

}
