#include "hdf.h"

main( )
{
   int32 status, file_id, an_id, ann_id, ann_num;
   int32 *ann_list;
   uint16 obj_tag, obj_ref;
   int32 annot_type;

   /* Create the HDF file. */
   file_id = Hopen("Example6.hdf", DFACC_RDWR, 0);

   /* Initialize the AN interface and obtain an interface id. */
   an_id = ANstart(file_id);

   /* Set the annotation type to be a data description. */
   annot_type = AN_DATA_DESC;

   /* Set the tag to be a data identifier. */
   obj_tag = DFTAG_DIA;

   /* Set the reference number to be the first object. */
   obj_ref = 0;

   /* Get the number of object descriptions. */
   ann_num = ANnumann(an_id, annot_type, obj_tag, obj_ref);

   /* Allocate space for the annotation identifier. */
   ann_list = HDmalloc(ann_num * sizeof(int32));

   /* Get the list of object descriptions. */
   status = ANannlist(an_id, annot_type, obj_tag, obj_ref, ann_list);

   /* Terminate access to the annotation. */
   status = ANendaccess(ann_id);

   /* Terminate access to the AN interface. */
   status = ANend(an_id);

   /* Free the space allocated for the annotation identifier. */
   HDfree(ann_list);

   /* Close the file. */
   status = Hclose(file_id);

}
