#include "hdf.h"
#include <string.h>

main( )
{

   int32 file_id, an_id, ann_id, vgroup_id, ann_type;
   uint16 obj_tag, obj_ref;
   intn status;
   static char file_label[] = "This is a file label.";

   /* Create the HDF file. */
   file_id = Hopen("Example6.hdf", DFACC_CREATE, 0);

   /* Initialize the AN interface and obtain an interface id. */
   an_id = ANstart(file_id);

   /* Set the file annotation type to be a file label. */
   ann_type = AN_FILE_LABEL;

   /* Create the file label and obtain an annotation id. */
   ann_id = ANcreatef(an_id, ann_type);

   /* Write the label to the file. */
   status = ANwriteann(ann_id, file_label, strlen(file_label));

   /* Create a vgroup. */
   status = Vstart(file_id);
   vgroup_id = Vattach(file_id, -1, "w");
   status = Vdetach(vgroup_id);
   status = Vend(file_id);

   obj_tag = DFTAG_VG;
   obj_ref = 0;

   /* Create the data description label. */
   ann_id = ANcreate(an_id, obj_tag, obj_ref, AN_DATA_DESC);

   /* Write the label to the file. */
   status = ANwriteann(ann_id, file_label, strlen(file_label));

   /* Terminate access to the annotation. */
   status = ANendaccess(ann_id);

   /* Terminate access to the AN interface. */
   status = ANend(an_id);

   /* Close the file. */
   status = Hclose(file_id);

}
