#include "hdf.h"

#define X_LENGTH 3
#define Y_LENGTH 2
#define Z_LENGTH 5

main( )
{

   /* Create the data array. */
   static float32 sds_data[X_LENGTH][Y_LENGTH][Z_LENGTH] =
      {  1,  2,  3,  4,  5,
         6,  7,  8,  9, 10,
        11, 12, 13, 14, 15,
        16, 17, 18, 19, 20,
        21, 22, 23, 24, 25,
        26, 27, 28, 29, 30 };

   /* 
   * Create the array that will hold the dimensions of 
   * the data array.
   */
   int32 dims[3] = {X_LENGTH, Y_LENGTH, Z_LENGTH};
   intn refnum, status;
   static char object_desc[] = "This is an object description.";
   static char object_label[] = "This is an object label.";

   /* Write the data to the HDF file. */
   status = DFSDadddata("Example1.hdf", 3, dims, (VOIDP)sds_data);

   /* Get the reference number for the newly written data set. */
   refnum = DFSDlastref( );

   /* Assign the object label to the scientific data set. */
   status = DFANputlabel("Example1.hdf", DFTAG_NDG, refnum, \
                        object_label); 

   /* Assign the object description to the scientific data set. */
   status = DFANputdesc("Example1.hdf", DFTAG_NDG, refnum, \
                         object_desc, strlen(object_desc));

}
