// $Id: hdfv.c,v 1.3 1996/08/04 23:51:59 yotam Exp yotam $

#include <ctype.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>

#include <iostream.h>
#include <strstream.h>

#include <tk.h>
#include "hdfCmd.h"
#include "debug.h"

#if !defined(VERSION)
# define VERSION  "Unknown"
#endif

////////////////////////////////////////////////////////////////////////
static char *
strClone(const char *s)
{
   unsigned  l = strlen(s);
   char     *ns = new char[l + 1];
   (void)strcpy(ns, s);
   return(ns);
} // strClone


////////////////////////////////////////////////////////////////////////
static void
showTclError(Tcl_Interp* interp, const char* scandid)
{
    const char *errInfo = Tcl_GetVar(interp, "errorInfo", 
                                     TCL_GLOBAL_ONLY);
    cerr << "Failed to evaluate " << scandid << endl <<
      "result: " << interp->result << endl <<
      "errorInfo: " << errInfo << endl << 
      "errorLine=" << interp->errorLine << endl;
}

////////////////////////////////////////////////////////////////////////
static bool
pathFindEval
(
   Tcl_Interp                *interp,
   unsigned                   nd, 
   const char *const * const  dirs, 
   const char                *script
)
{
   bool         ok = true;
   struct stat  dumStat;
   bool         found = false;
   char        *fullPath = 0;
   unsigned     di, fullPathSize = 0, lef = strlen(script);
   for (di = 0;  ok && !found && di < nd;  di++)   
   {
      unsigned  ld = strlen(dirs[di]);
      unsigned  fullPathLen = ld + lef + 2;
      if (fullPathSize < fullPathLen)
      {
         if (fullPath)
         {
            delete [] fullPath;
         }
         fullPathSize = fullPathLen;
         fullPath = new char[fullPathSize];
      }
      if (ld > 0)
      {
         (void)strcpy(fullPath, dirs[di]);
         fullPath[ld] = '/';
         (void)strcpy(fullPath + ld + 1, script);
         DPRNL("Trying fullPath=" << fullPath);
      }
      const char  *ccandid = (ld > 0 ? fullPath : script);
      char        *scandid = strClone(ccandid);
      if (stat(scandid, &dumStat) == 0)
      {
         found = true;  DPRNL("found " << scandid);
         ok = (Tcl_EvalFile(interp, scandid) == TCL_OK);
         if (!ok)
         {
            showTclError(interp, scandid);
         }
      }
   }
   return(ok);
} // pathFindEval


#define SZA(a) (sizeof(a) / sizeof(a[0]))

////////////////////////////////////////////////////////////////////////
static bool
initScripts(Tcl_Interp *interp, int argc, const char * const * const argv)
{
   static const char *envNames[] = {"PATH", "TCL_LIBRARY", "HOME"};
   static const char *cenvdirs[SZA(envNames)];
   static       char *envdirs[SZA(envNames)];

   bool  ok = true;

   // copy paths and count colons within paths to get # of directories.
   int  i, nd = 2; // 2  for current + exec-dircetory
   for (i = SZA(envNames);  i--;)
   {
      envdirs[i] = 0;
      cenvdirs[i] = getenv(envNames[i]);
      const char *envdir = cenvdirs[i];
      if (envdir)
      {
         nd++;
         const char  *colon;
         for (colon = envdir - 1; (colon = strchr(colon + 1, ':')) != 0;  nd++);
         envdirs[i] = strClone(envdir);
      }
   }

   char  **dirs = new char *[nd];

   dirs[0] = ""; // current directory
   nd = 1;

   // get directory of executable.
   const char *argv0 = argv[0];
   char  *execdir = 0;
   const char  *slash = strrchr(argv0, '/');
   if (slash)
   {
      int  l = slash - argv0;
      dirs[1] = execdir = new char[l + 1];
      strncpy(execdir, argv0, l);
      execdir[l] = '\0';
      nd = 2;
   }
   // else we search PATH anyway.

   // Split the paths, by nullifying colons. Set dirs to directory positions.
   for (i = SZA(envNames);  i--;)
   {
      char  *pos = envdirs[i];
      if (pos)
      {
         char  *colon = dirs[nd++] = pos;
         while ((colon = strchr(pos, ':')) != 0)
         {
            *colon = '\0';
            pos = colon + 1;
            dirs[nd++] = pos;
         }
      }
   }

   ok = ok && pathFindEval(interp, nd, dirs, "fs.tcl") && 
              pathFindEval(interp, nd, dirs, "hdfv.tcl");
   if (ok)
   {
      ostrstream  hdfvMain;
      hdfvMain << "hdfvMain";
      for (i = 0;  i < argc;  i++)
      {
         hdfvMain << ' ' << argv[i];
      }
      hdfvMain << ends;
      char  *strHdfvMain = strClone( hdfvMain.str() );
      DPRNL("strHdfvMain=" << strHdfvMain);
      ok = (Tcl_Eval(interp, strHdfvMain) == TCL_OK);
      if (!ok)
      {
         showTclError(interp, strHdfvMain);
      }
      delete [] strHdfvMain;
#if defined(__GNUC__)
      hdfvMain.freeze(0);
#endif
   }

   if (execdir) 
   {
      delete [] execdir;
   }
   for (i = SZA(envNames);  i--;)
   {
      if (envdirs[i])
      {
         delete [] envdirs[i];
      }
   }
   delete [] dirs;
   DPRNL("ok=" << (int)ok);
   return(ok);
} // initScripts


////////////////////////////////////////////////////////////////////////
int
main(int argc, char **argv)
{
   bool  ok = true;
   DPRNL("pid=" << getpid());
   // Tk_Main(argc, argv, appInit); because appInit cannot get argv

   char  *basename = strrchr(argv[0], '/');
   basename = (basename ? basename + 1 : argv[0]);

   int  i; bool silent = false;
   for (i = 1;  i < argc && !silent;  silent = !strcmp(argv[i++], "-silent"));
   if (!silent)
   {
      cerr << basename << " Version " << VERSION << endl;
   }

   char *Basename = strClone(basename);
   Basename[0] = toupper(Basename[0]);
   Tcl_Interp  *interp = Tcl_CreateInterp();

   if (Tcl_Init(interp) == TCL_ERROR ||
       Tk_Init(interp) == TCL_ERROR || 
       hdf_Init(interp) == TCL_ERROR)
   {
      cerr << basename << ": failed to initialize Tcl-package(s)" << endl;
      ok = false;
   }
   else
   {
      (void)Tcl_SetVar2(interp, "hdfvGlob","version", VERSION, TCL_GLOBAL_ONLY);
      Tk_Window  mainWindow = Tk_MainWindow(interp);
      Tk_SetClass(mainWindow, Basename);
   }
   

   ok = ok && initScripts(interp, argc, argv);
   if (ok)
   {
      Tk_MainLoop();
   }
   
   delete [] Basename;
   return(!ok);
} // main
