/* $Id: hdfCmd.h,v 1.2 1996/05/09 04:31:51 yotam Exp $ */
#ifndef _hdfCmdTcl_
#define _hdfCmdTcl_

#if 0

   TCL extension for limited HDF-interface (See NCSA).
   Currently, just for vgroup/vdata queries.

            Yotam Medini  
            February 1996
            yotam@sj-coop.net

   The following commands are supported. 
      Note: General parameter conventions:
        -  If parentId = -1, look at the lone (parent-less) Vgroup-s/Vdata-s
        -  If <first> or <last> used, list is outputed similar to lrange.
           By default, first=0, last=end.

   +  hdf <HDFfilename> 
      Open HDFfilename as an HDF file. 
      Return filename if succeed, empty string otherwise.
      HDFfilename becomes a command with the following options.

   + <HDFfilename> close
     Close the file and destroy the command.

   + <HDFfilename> nsubgroup <parentId> 
   + <HDFfilename> nsubdata  <parentId>
     Return the # of Vgroup-s (Vdata-s) under parentId.

   + <HDFfilename> listsubgroup <parentId> [first [last]]
   + <HDFfilename> listsubdata  <parentId> [first [last]]
     Return list of  of Vgroup-s (Vdata-s) under parentId.

   + <HDFfilename> name  <id>
   + <HDFfilename> class <id>
     Return the name and class of given id which can be Vgroup or Vdata.

   + <HDFfilename> ndatafield <id>
     Return # of fields define d for Vdata id.

   + <HDFfilename> ndatarecord <id>
     Return # of records for Vdata id.

   + <HDFfilename> datafield <id> <fi>
     Return the definition of the fi-th field of Vdata id - 
     in the following format:
        <fieldname> <num_type> <typename> order
     For example:
        PlaneDirection  5  DFNT_FLOAT32  2
 
   + <HDFfilename> data <id> <fi> [first [last [firstComp [compLimit]] ]]
     Return list of data for Vdata id, of the fi-th field.
     If the order is > 1, the values - for each record - 
     will be separetd by commas only.

        For example order=2, may result in:
              2.718281,1.414213 3.141592,6.0  1,0

     firstComp and compLimit can be used to select just some components
     of the field that has order components.
     By defualt firstComp=0, compLimit=-1 (unlimited).

     Characters (DFNT_CHAR8) will be output as integers to avoid
     confusion with space,commas in the data.
     User can use TCL-s   
        format "%c"
     to 'see' the character.

   + <HDFfilename> id <id>
     Returns "g", "d" or "n" according to the case of which <id> is:
     a Vgroup, a Vdata or otherwise.

   + <HDFfilename> getid <id>
     Returns next Vgroup id following <id>. If <id>=-1, get the first.
     If non exist return -1. See  Vgetid().
   
   + <HDFfilename> sgetid <id>
     Returns next Vdata id following <id>. If <id>=-1, get the first.
     If non exist return -1. See VSgetid().
   
#endif

#include <tcl.h>

extern "C" int
hdf_Init(Tcl_Interp *interp);


#endif /* _hdfCmdTcl_ */
