# $Id: fs.tcl,v 1.4 1996/08/04 23:51:59 yotam Exp yotam $
# File Selector

########################################################################
# Debug routine.
proc yfsdputs {args} {
   if {0} {
      puts stderr $args;
   }
}; # yfsdputs


########################################################################
# maximize vaiable by value
########################################################################
proc maximize {varName val} {
   upvar $varName var;
   if {$var < $val} {
      set var $val;
   }
}; # maximize


########################################################################
# Unique sort
proc lusort {l} {
   set ls [lsort $l];
   set lus {};
   if [llength $ls] {
      set lastin [format "%sELSE" [lindex $ls 0]];
      foreach t $ls {
	 if [string compare $lastin $t] {
	    lappend lus $t;
            set lastin $t;
         }
      }
   }
   return $lus
}; # lusort


########################################################################
proc yfs { \
   {title "Select a file"} \
   {wmtitle "File Selector"} \
   {filter *} \
   {wmConfCallback ""} \
   {wmConfArgs {}} \
} \
{
   global yfsGlob;

   if {![info exists yfsGlob(dir)]} {
      yfsdputs "Initializing yfs defaults";
      set yfsGlob(filter) $filter;
      set yfsGlob(dir) ".";  # cwd
      set yfsGlob(curFile) "";  # cwd
   }

   toplevel .yfs;
   wm title .yfs $wmtitle;
   wm resizable .yfs 0 0;
   if {[string compare $wmConfCallback ""]} {
      eval $wmConfCallback .yfs $wmConfArgs;
   }

   # bind .yfs <Key-Tab> [list yfsdputs yfsTab];

   label .yfs.title  -text $title;
   pack .yfs.title -side top -pady 8;

   set frmDirFilt [frame .yfs.frmDirFilt];
   pack $frmDirFilt -side top -padx 10 -pady 6 -fill x;

      # Current selected directory
      set fcurdir [frame $frmDirFilt.fcurdir];
      pack $fcurdir -side left -expand true -fill x -padx 6;
      set lblDir [label $fcurdir.lblDir -text Directory:];
      pack $lblDir -side top -anchor w;
      set ecurdir [entry $fcurdir.ecurdir -textvariable yfsGlob(dir) \
                   -state disabled];
      pack $ecurdir -side right -expand true -fill x;
      set yfsGlob(curdirEntry) $ecurdir;

      # file filter
      set yfsGlob(filtFrm) [frame $frmDirFilt.ffilter];
      pack $yfsGlob(filtFrm) -side right -padx 6 -pady 6;
      set fbut [button $yfsGlob(filtFrm).but -text Filter: -state disabled \
                -command yfsFilterEditCommit];
      pack $fbut -side top;
      set efilter [entry $yfsGlob(filtFrm).efilter \
                   -textvariable yfsGlob(filter) -width 8];
      bind $efilter <FocusIn> yfsFilterFocus;
      bind $efilter <Return> yfsFilterEditCommit;
      pack $efilter -side bottom -pady 2 -anchor w -fill x;

   set control [frame .yfs.control];
   pack $control -side top -padx 8 -fill x;

      # Frame Directory Switch (via sub-directories or buttons) and filter
      set fswdir [frame $control.fswdir];
      pack $fswdir -side left; # -padx 4;

         # List of sub-directories to move to
         set fsubdirs [frame $fswdir.fsubdirs];
         pack $fsubdirs -side top -pady 8;
            label $fsubdirs.lbl -text Sub-directories:
            pack $fsubdirs.lbl -side top -anchor w;
            set dirlbx [listbox $fsubdirs.lbx -height 8 \
                        -yscrollcommand [list $fsubdirs.sy set]];
            scrollbar $fsubdirs.sy -orient vertical \
                      -command [list $dirlbx yview];
            bind $dirlbx <ButtonRelease-1> yfsUpdateDir;
            pack $dirlbx -side left -fill x -expand true;
            pack $fsubdirs.sy -side right -fill y -anchor w;
            set yfsGlob(dirlbx) $dirlbx;

         # Buttons for switching dirs
         set fspecdir [frame $fswdir.fspecdir];
         pack $fspecdir -side top -padx 8;
         foreach bspecdir {home cwd} {
            set b [button $fspecdir.$bspecdir -text [string toupper $bspecdir] \
                   -width 4 -command [list yfsSpecialDir $bspecdir]];
            pack $b -side left -padx 10;
         }

      # List of files to pick from
      set ffiles [frame $control.frmFiles];
      pack $ffiles -side right -pady 8 -padx 4;

      label $ffiles.lbl -text Files:
      pack $ffiles.lbl -side top;

      set filelbx [listbox $ffiles.lbx -width 16 -height 10 \
                  -yscrollcommand [list $ffiles.sy set]];
      scrollbar $ffiles.sy -orient vertical -command [list $filelbx yview];
      bind $filelbx <ButtonRelease-1> yfsUpdateFile;
      pack $filelbx -side left -fill x;
      pack $ffiles.sy -side right -fill y -anchor w;
      set yfsGlob(filelbx) $filelbx;

   # Current selected file
   set fselfile [frame .yfs.fselfile];
   pack $fselfile -side top -fill x -padx 10 -pady 8;
      set lblFile [label $fselfile.lblFile -text File:];
      pack $lblFile -side left -padx 2;
      set yfsGlob(fileEntry) \
          [entry $fselfile.fileEntry -textvariable yfsGlob(curFile)];
      bind $yfsGlob(fileEntry) <Return> yfsSelect;
      # the following break, prevent the focus traversal!
      bind $yfsGlob(fileEntry) <Tab> {yfsFileComplete; break}
      pack $yfsGlob(fileEntry) -side right -expand true -fill x;

   set fokc [frame .yfs.fokc];
   pack $fokc -side bottom -pady 10 -padx 10;
      set ok [button $fokc.ok -text OK -width 5 -command yfsSelect;];
      set cancel [button $fokc.cancel -text Cancel -command yfsCancel];

      set packpar [list -padx 16 -pady 10  -expand true -fill both];
      eval pack $fokc.ok -side left $packpar
      eval pack $fokc.cancel -side right $packpar


   yfsFillListboxes;   
   yfsXviewRight;
   focus $yfsGlob(fileEntry);
   set yfsGlob(Done) 0;
   set currGrab [grab current .yfs];

   grab set .yfs;
   tkwait variable yfsGlob(Done)
   grab release .yfs;

   if [string compare $currGrab ""] {
      grab $currGrab;
   }
   yfsdputs "\n**** yfs returns: $yfsGlob(curFile) ****";
   destroy .yfs;
   return $yfsGlob(curFile);
}; # yfs


########################################################################
proc yfsFilterFocus {} {
   global yfsGlob;
   yfsdputs yfsFilterFocus;

   set oldFilter $yfsGlob(filter);

   set currGrab [grab current .yfs];
   yfsdputs "yfsFilterFocus: currGrab=$currGrab";

   set but $yfsGlob(filtFrm).but
   set yfsGlob(filterEditDone) 0;
   $but configure -state normal;
   

   grab set $yfsGlob(filtFrm);
   tkwait variable yfsGlob(filterEditDone)
   grab release $yfsGlob(filtFrm);

   if {![string compare $yfsGlob(filter) ""]} {
      set yfsGlob(filter) *; # empty means everything
      bell;
   }
   
   if [string compare $yfsGlob(filter) $oldFilter] {
      if {[string first / $yfsGlob(filter)] >= 0} {
         bell; # warn
         set yfsGlob(filter) $oldFilter;
      } else {
         yfsFillFileListbox;
      }
   }

   focus $yfsGlob(fileEntry);
   if [string compare $currGrab ""] {
      grab $currGrab;
   }
}; # yfsFilterFocus


########################################################################
proc yfsSpecialDir {specDir} {
   global yfsGlob env;
   yfsdputs "yfsSpecialDir specDir=$specDir";
   set nd "";
   if {![string compare $specDir home]} {
      set nd $env(HOME)
   } elseif {![string compare $specDir cwd]} {
      set nd .
   }

   if {[file isdirectory $nd]} {
      yfsNewdir $nd;
   } else {
      bell;
   }
}; # yfsSpecialDir


########################################################################
proc yfsFilterEditCommit {} {
   global yfsGlob;
   yfsdputs yfsFilterEditCommit;

   set but $yfsGlob(filtFrm).but
   $but configure -state disabled;
   set yfsGlob(filterEditDone) 1;

}; # yfsFilterEditCommit


########################################################################
proc yfsFillListboxes {} {
   yfsFillDirListbox;
   yfsFillFileListbox;
}; # yfsFillListboxes



########################################################################
proc yfsFillDirListbox {} {
   global yfsGlob;
   set dir $yfsGlob(dir);
   set allEnt [glob -nocomplain $dir/*];            yfsdputs "allEnt=$allEnt";

   set pathlen [string length $dir/];

   # Sub Directories
   set subdirs {};
   set maxLen 2;
   foreach e $allEnt {
      if [file isdirectory $e] {
         set d [string range $e $pathlen end];
         set l [string length $d];
         maximize maxLen $l;
         lappend subdirs $d;
      }
   }
   set subdirs [lusort $subdirs];
   set dirlbx $yfsGlob(dirlbx);
   $dirlbx delete 0 end;
   $dirlbx insert 0 ..
   eval [list $dirlbx insert 1] $subdirs;
   $dirlbx configure -width $maxLen;
}; # yfsFillDirListbox



########################################################################
proc yfsFillFileListbox {} {
   global yfsGlob;
   set dir $yfsGlob(dir);
   set filter $yfsGlob(filter);
   set filtEnt [glob -nocomplain $dir/$filter];     yfsdputs "filtEnt=$filtEnt";

   set pathlen [string length $dir/];

   # Files
   set files {};
   set maxLen 0;
   foreach e $filtEnt {
      if ![file isdirectory $e] {
         set f [string range $e $pathlen end];
         set l [string length $f];
         maximize maxLen $l;
         lappend files $f;
      }
   }
   set files [lusort $files];
   set filelbx $yfsGlob(filelbx);
   $filelbx delete 0 end;
   eval [list $filelbx insert 0] $files;
   $filelbx configure -width $maxLen;
}; # yfsFillFileListbox



########################################################################
proc lbxSelection {lbx} {
   set currsel [$lbx curselection];
   set item [$lbx get $currsel];
   return $item;
}; # lbxSelection


########################################################################
proc yfsUpdateDir {} {
   global yfsGlob;
   set dir $yfsGlob(dir);
   set subdir [lbxSelection $yfsGlob(dirlbx)];
   
   yfsdputs "yfsUpdateDir: dir=$dir, subdir=$subdir";
   if ![string compare $dir "."] {
      set newdir $subdir;
   } else {
      set newdir $dir/$subdir; 

      # but if going up, we may do some canceling.
      if ![string compare $subdir ..] {
         if ![string compare $dir /] {  
            set newdir /;        yfsdputs "the same /";
         } elseif [string compare $dir ..] {
            set l [string length $dir];
            set tail3 xxx;
            if {($l >= 3)} {
                set tail3 [string range $dir [expr $l-3] end];
            }
            yfsdputs "tail3=$tail3";
            if [string compare $tail3 /..] {
               # Let's climb back
               set lastSlash [string last / $dir]; # cannot be 0
               if {$lastSlash > 0} {
                  set newdir [string range $dir 0 [expr $lastSlash-1]];
               } else {
                  set newdir "";   yfsdputs cwd;
               }
            }
         }
      }
   }

   if {![string compare $newdir ""]} {
      set newdir .;
   }
   yfsNewdir $newdir;
}; # yfsUpdateDir


########################################################################
proc yfsNewdir {newdir} {
   global yfsGlob;
   set yfsGlob(dir) $newdir;
   set yfsGlob(curFile) "";
   if [string compare $newdir .] {
      set yfsGlob(curFile) "$newdir/";
   }
   yfsFillListboxes;
   yfsXviewRight;
}; # yfsNewdir


########################################################################
proc yfsUpdateFile {} {
   global yfsGlob;
   set dir $yfsGlob(dir);
   set base [lbxSelection $yfsGlob(filelbx)];
   set file $base;
   if [string compare $dir "."] {
      set file $dir/$base;
   }
   yfsdputs "yfsUpdateFile: dir=$dir, base=$dir, file=$file";
   set yfsGlob(curFile) $file;
   yfsXviewRight;
}; # yfsUpdateFile



########################################################################
proc yfsSelect {} {
   global yfsGlob;
   yfsdputs yfsSelect;
   set file $yfsGlob(curFile);
   yfsdputs "yfsSelect: file=$file";
   if [file isdirectory $file] {
      # trim last slash(es) except for root /
      set l [expr [string length $file] - 1];
      while {$l && ($l == [string last / $file])} {
         set l [expr $l-1];
         set file [string range $file 0 $l];
      }
      yfsNewdir $file;
   } elseif {[file readable $file]} {
      set yfsGlob(Done) 1;
   } else {
      bell;
   }
}; # yfsSelect


########################################################################
proc yfsCancel {} {
   global yfsGlob;
   yfsdputs yfsCancel;
   set yfsGlob(curFile) "";
   set yfsGlob(Done) 1;
}; # yfsCancel


########################################################################
proc yfsFileComplete {} {
   global yfsGlob;

   set fe $yfsGlob(curFile)
   set cand [glob -nocomplain $fe*];
   set nCand [llength $cand];
   yfsdputs "yfsFileComplete: cand=$cand, nCand=$nCand";
   if {$nCand == 0} {
      bell;
   } elseif {$nCand == 1} {
      set yfsGlob(curFile) [lindex $cand 0];
   } else {
      set nextCommon $fe
      set common     $fe.Different; # just to enter the loop
      set commonLength [string length $fe];
      set firstCand [lindex $cand 0];        
      while {[string compare $common $nextCommon] != 0} {
         set common $nextCommon;
         set nextCommon [string range $firstCand 0 $commonLength];
         for {set i 1} {$i < $nCand} {incr i} {
            set candi [lindex $cand $i];
            yfsdputs "i=$i, candi=$candi";
            set candhead [string range $candi 0 $commonLength]
            if {[string compare $nextCommon $candhead]} {
               # no match for $nextCommon. break the loops
               set i $nCand;
               set nextCommon $common;
            }
         }
               
         incr commonLength;
      }
      set yfsGlob(curFile) $common;
   }
   $yfsGlob(fileEntry) icursor end;
   $yfsGlob(fileEntry) xview end;
}; # yfsFileComplete


########################################################################
proc yfsXviewRight {} {
   global yfsGlob;
   update; # let widget repack
   $yfsGlob(curdirEntry) xview end;   
   $yfsGlob(fileEntry) xview end;   
}; # yfsXviewRight
