/*
 *	File:		xds.h
 *	Contents:	Global include file for all modules of xds
 *
 */

#define	STRNG20			20
#define	STRNG40			40
#define STRNG80			80
#define	STRNG160		160
#define STRNG256		256
#define	RESERVED_COLORS	2
#define	PI				(double)3.141592654

#define XDS_GREATER(A,B)	((A) > (B) ? (A) : (B))
#define XDS_SMALLER(A,B)	((A) < (B) ? (A) : (B))

/*
 * Data to pixel conversion macros
 * Note that I reserve the 1st 2 and the last 2 color entries in the color
 * map for black and white values.
 */
#define	XDS_CNV2PIX(A,B,C,D,E)	\
	( (A <= B) ? (unsigned char) RESERVED_COLORS : \
	 ((A >= C) ? (unsigned char) E+1 : \
				 (unsigned char)(RESERVED_COLORS+(A-B)*D)) )

#define	XDS_CNV2SPLIT(A,B,C,D,E,F)	\
	( (A <= B) ? (unsigned char) RESERVED_COLORS+D : \
	 ((A >= C) ? (unsigned char) RESERVED_COLORS+E+F : \
				 (unsigned char)(RESERVED_COLORS+F+(A-B)*D)) )

typedef struct A_Coord_t {
    int x,y,z;
} A_Coord_t;

typedef struct A_VRect_t {
	int red,green,blue;
    double  intensity;
    double  opacity;
} A_VRect_t;

typedef enum {
	HDF, MIRIAD
} A_FileFormat_t;

/* Data Structure */
typedef struct {
	A_FileFormat_t	format;
	int		rank;
	int		scale;
	int		numSDs;
	int32	dims[3];
	float32	min,max,range,rangeFrac,rangeFracSplit;
	float32	***data,*scaleStr[3];
	char	dataName[STRNG80];
	char	dataUnit[STRNG40];
	char	dataFmt[STRNG40];
	char	label[3][STRNG40];
	char	units[3][STRNG40];
	char	fmt[3][STRNG40];
	char	pathName[STRNG160];
#ifdef MIRIADFMT
	int		tno;
	float32	crval[3];
	float32	crpix[3];
	float32	cdelt[3];
#endif
} A_Data_t;

char	*axesLabels[3];
char	msg[256];

#ifdef RIOS
#define Strcpy(a,b)	strncpy(a,b,strlen(b)+1)
#endif

/*
  Macros used for debugging purpose : if DEBUG is define,
  print a message, otherwise they do nothing.
  Gilles Bourhis Jan 93
 */
#ifdef DEBUG
#define DBPRINT(mes) fputs(mes, stdout)
#define DBPRINTARG(mes, arg) fprintf(stdout, mes, arg)
#define DBPRINT2ARGS(mes, arg1, arg2) fprintf(stdout, mes, arg1, arg2)
#else
#define DBPRINT(mes)
#define DBPRINTARG(mes, arg)
#define DBPRINT2ARGS(mes, arg1, arg2)
#endif
