/*
 * National Center for SuperComputing Applications, University of Illinois
 *
 * This NCSA software product is public domain software.  Permission
 * is hereby granted to do whatever you like with it. Should you wish
 * to make a contribution towards the production of this software, please
 * send us your comments about your experience with the software,  why
 * you liked or disliked it, how you use it, and most importantly, how it
 * helps your work. We will receive your comments at softdev@ncsa.uiuc.edu.
 *
 * Please send bug reports to bugs@ncsa.uiuc.edu
 *
 * Author: Eng-Whatt Toh, National Center for Supercomputing Applications
 *         ewtoh@ncsa.uiuc.edu
 */

/*
 *	File:		td_main.c
 *	Contents:	Main initialization/termination routines for td module
 *
 */

#include "td_com.h"

extern	void	td_Init();
extern	void	gr_Init();
extern	void	gr_ProcessLoop();

static char xdslogfilename[1024]; /* td_logFile will point to this */
/*
 *	Entry point into X DataSlice
 */
main(argc,argv)
int 	argc;
char	*argv[];
{
	td_Init(argc,argv);
	
	gr_ProcessLoop();

}


/*
 *	Initialize X DataSlice
 */
void
td_Init(argc,argv)
int		argc;
char	*argv[];
{
	FILE *fp;
	char label[20];
	extern char *getcwd();

	td_version = 2.2;
	td_release = 2; /* normal */
	axesLabels[0] = (char*) malloc(2);
	axesLabels[1] = (char*) malloc(2);
	axesLabels[2] = (char*) malloc(2);
#ifdef RIOS
	Strcpy(axesLabels[0],"X");
	Strcpy(axesLabels[1],"Y");
	Strcpy(axesLabels[2],"Z");
#else
	strcpy(axesLabels[0],"X");
	strcpy(axesLabels[1],"Y");
	strcpy(axesLabels[2],"Z");
#endif
	/* Initialize xdsLog file */
#ifdef XtSpecificationRelease
	sprintf(label,"XV11R4");
#else
	sprintf(label,"XV11R3");
#endif


/* ---- print brief message --- */
  printf ("NCSA X DataSlice v %3.1f.%d%s\n",td_version, td_release,td_relType);
  printf("February 1993, Jason Ng & Gilles Bourhis, National Center for Supercomputing Applications.\n");

/* xdsLog is now created in the home directory. jng nov 15 */

	sprintf(xdslogfilename, "%s/xdsLog",(char*) getenv("HOME"));
	td_logFile = xdslogfilename;

	if ((fp = fopen(td_logFile,"w")) != NULL)
	{
#ifdef LINT
#define COMPILEDATE "bidon"
#endif /* LINT */
#ifdef UNICOS
		sprintf(msg,
"Welcome to %s <V%3.1f.%d%s>!\n%s Cray Unicos client compiled on %s\nStart at %s",
		td_toolName,td_version,td_release,td_relType,label,COMPILEDATE,td_CurrentDate());
#else
#ifdef IRIS
		sprintf(msg,
"Welcome to %s <V%3.1f.%d%s>!\n%s IRIS IRIX client compiled on %s\nStart at %s",
		td_toolName,td_version,td_release,td_relType,label,COMPILEDATE,td_CurrentDate());
#else
#ifdef RIOS
		sprintf(msg,
"Welcome to %s <V%3.1f.%d%s>!\n%s IBM RIOS(AIX3.1) client compiled on %s\nStart at %s",
		td_toolName,td_version,td_release,td_relType,label,COMPILEDATE,td_CurrentDate());
#else
#ifdef AIX
		sprintf(msg,
"Welcome to %s <V%3.1f.%d%s>!\n%s IBM AIX client compiled on %s\nStart at %s",
		td_toolName,td_version,td_release,td_relType,label,COMPILEDATE,td_CurrentDate());
#else
#ifdef SUN3
		sprintf(msg,
"Welcome to %s <V%3.1f.%d%s>!\n%s SUN3 OS client compiled on %s\nStart at %s",
		td_toolName,td_version,td_release,td_relType,label,COMPILEDATE,td_CurrentDate());
#else
#ifdef SUN4
		sprintf(msg,
"Welcome to %s <V%3.1f.%d%s>!\n%s SUN4/SparcStation client compiled %s\nStart at %s",
		td_toolName,td_version,td_release,td_relType,label,COMPILEDATE,td_CurrentDate());
#else
#ifdef BSD386J
                sprintf(msg,
"Welcome to %s <V%3.1f.%d%s>!\n%s 386BSD/Intel client compiled %s\nStart at %s",
                td_toolName,td_version,td_release,td_relType,label,COMPILEDATE,td_CurrentDate());
#else
#ifdef SUN386
		sprintf(msg,
"Welcome to %s <V%3.1f.%d%s>!\n%s SUN386i OS client compiled on %s\nStart at %s",
		td_toolName,td_version,td_release,td_relType,label,COMPILEDATE,td_CurrentDate());
#else
#ifdef MOTOROLA
		sprintf(msg,
"Welcome to %s <V%3.1f.%d%s>!\n%s Motorola M88K client compiled on %s\nStart at %s",
		td_toolName,td_version,td_release,td_relType,label,COMPILEDATE,td_CurrentDate());
#else
#ifdef TEKXD88
		sprintf(msg,
"Welcome to %s <V%3.1f.%d%s>!\n%s Tektronix XD88 client compiled on %s\nStart at %s",
		td_toolName,td_version,td_release,td_relType,label,COMPILEDATE,td_CurrentDate());
#else
		sprintf(msg,
"Welcome to %s <V%3.1f.%d%s>!\n%s Client compiled on %s\nStart at %s",
		td_toolName,td_version,td_release,td_relType,label,COMPILEDATE,td_CurrentDate());
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
		gr_TextInitBuff((long)strlen(msg));
		fprintf(fp,"%s",msg);
		fclose(fp);
		chmod(td_logFile,0000700|0000070|0000007);
	}
	else
	{
		fprintf(stderr,"Error\t: Cannot open log file %s\n",td_logFile);
		exit(1);
	}

	if ((td_dirName = getcwd((char *)NULL,STRNG160)) == NULL)
	{
		gr_TextMsgOut("WARNING: Cannot get current directory pathname\n");
		td_dirName = td_dirDefName;
	};

	gr_Init(argc,argv);

#ifdef DTMOK
   DTM_showInfo();
#endif

} /* main */


/*
 *	Terminate X DataSlice
 */
void
td_Terminate()
{
	exit(0);
}
