/* contains dtm stuff- for receiving palettes from ximage */
#include "gr_com.h"
#include <stdio.h>

#ifdef DTMOK
#include "dtm.h"
#include "sds.h"
#include "ris.h"


#define TIME_INTERVAL 2000  /* check dtm port every 2 sec */

/* --- DTM related variables --- */
static char IN_HOST_NAME[120];
static int  IN_PORT_NUMBER;

static int inPort = -55;
static int DTM_state = 0; 
static char header[DTM_MAX_HEADER];
static unsigned char palette[256*3];
static int ignoreDTMflag = 0;

/* ------------------------------------------------------- */
setignoreDTM (s) int s; { ignoreDTMflag = s; }

/* ------------------------------------------------------- */
int DTM_showInfo () {
  char ss[100];
  sprintf(ss,"%s", (char*)  getenv("XDSPORT"));

  if (!strcmp(ss,"(null)") ) {
	 sprintf(IN_HOST_NAME,"");
	 IN_PORT_NUMBER = 4321;
   }
  else {
	int i;
	if (ss[0] == ':')	/* test if host field is empty */
	  {			/* gbourhis Feb 93 */
	    sprintf(IN_HOST_NAME,"");
	    sscanf(ss+1, "%d", &IN_PORT_NUMBER);
	  }
	else
	  {
	    for(i=0;i<strlen(ss);i++) if ( ss[i]==':') { ss[i] = ' '; break; }
	    sscanf(ss,"%s %d", IN_HOST_NAME, &IN_PORT_NUMBER);
	  }
	if(IN_PORT_NUMBER <1) {
			printf("host = [%s] portnumber= [%d]\n", IN_HOST_NAME, IN_PORT_NUMBER);
			printf("Possibly bad port number specified. DTM may not work.\n");
 			beep();
			return;
 		}
	}
 
  beep();
  printf("\n*************************************************************\n");
  printf("This version of xds has DTM linked to it.\n");
  printf("It will receive palettes and sds's over port [%s:%d]\n",
	 IN_HOST_NAME, IN_PORT_NUMBER);
  printf("To use a different port instead, you must define the environment\n");
  printf("variable XDSPORT to \"machinename:portnumber\" and restart XDataSlice\n");
  printf("Use the DTM toggle to start\n");
  printf("*************************************************************\n\n");
  beep();
}

/* ------------------------------------------------------- */
/* toggle on dtm */
static int DTM_init = 0;
int DTM_setControlOn ( w, client_data, call_data)
Widget   w;
caddr_t  client_data;
caddr_t  call_data;

{
   /* start up a DTM connection if not already started  */
		if (DTM_init == 0) { 
			DTM_initialize();
			DTM_init = 1;
       }
		DTM_state = 1; /* on */

   /* set a timed request to wait for data */
		DTM_checkPortForData();
}
/* ------------------------------------------------------- */
/* toggle off dtm */
int DTM_setControlOff ( w, client_data, call_data)
Widget   w;
caddr_t  client_data;
caddr_t  call_data;

{
	DTM_init = 0;
	DTM_state = 0; /* off */
	DTMdestroyPort (inPort);
	fprintf(stderr,"dtm is now OFF\n"); fflush(stderr);
	gr_TextMsgOut("DTM is now OFF. All sending programs will block.\n");
}

/* ------------------------------------------------------- */

DTM_readData() {
	int i;
	float * sdsbuf;
	char dtmname[160]; /* name of DTM dataset if any */
	
	if (ignoreDTMflag != 0) return;

	if (DTM_state == 0) return;
	fprintf(stderr,"DTM_readData..\n"); fflush(stderr);

   	if (DTMerrno) {
         printf("DTM status: %s\n", DTMerrmsg(1));
  			exit(0);
         }
	if (DTMbeginRead(inPort,header,DTM_MAX_HEADER) == DTMERROR) {
	  fprintf(stderr, "Error reading DTM header\n");
	  exit(0);
         }

	/* gbourhis Jan 93: update to DTM 2.3			*/
	if (dtm_compare_class(header,PALclass)) {
	  DTMreadDataset(inPort,palette,768,DTM_CHAR);
	  DTMendRead(inPort);
	  gr_DTMpalLoad(&palette[0],&palette[256],&palette[512]);
	}
	else if (dtm_compare_class(header,SDSclass)) {
	  SDSgetTitle( header,dtmname, 80);
	  myDTMbossInit (dtmname);
      	} 

} /* DTM_readData */

/* ------------------------------------------------------- */

DTM_checkPortForData()
{
	char buff[256];
	static long count = 0;

	if (DTM_state == 0) return; /* dtm is off, don't bother */

	count++;
	if(count%4==0) DBPRINTARG("DTM_checkPort (%ld):\n",count);
	if (DTMavailRead(inPort))
	  if (!DTMerrno) 
	    DTM_readData();
	  else 
	    printf("DTM status: %s\n", DTMerrmsg(1));

	if (DTM_state == 1) /* continue to check DTM if DTM_state is on */
#ifdef XtSpecificationRelease	/* gbourhis Feb 1 93: we need an app_context */
	  XtAppAddTimeOut(XtWidgetToApplicationContext(gr_topLevel),
#else
	  XtAddTimeOut(
#endif
		       TIME_INTERVAL, DTM_checkPortForData, NULL);

} /* DTM_checkPortForData */

/* ------------------------------------------------------- */

int DTM_initialize()
{

	char buf[256];

   sprintf(buf,"%s:%d",IN_HOST_NAME,IN_PORT_NUMBER);
	/* gbourhis Jan 93: update to DTM 2.3			*/
   if (-1 == (inPort = DTMmakeInPort(buf, DTM_DEFAULT))) {
         printf("Couldn't use [%s]:%d for input\n", buf);
			return;
         }
   printf("DTM_initialize: Using port [%s] as DTM input\n", buf);

}
/* ------------------------------------------------------- */

/*
 *	Load color map with data received from DTM port.
 */

gr_DTMpalLoad (rval,gval,bval)
unsigned char* rval[256],gval[256],bval[256];
{

   A_CubeWind_t   *cubeWin;
   A_DsplWind_t   *dWin;
   A_HistWind_t   *hWin;
   A_AniWind_t    *aWin;
	A_BossWind_t   *bWin;

	gr_TextMsgOut("Hello..a Palette just came across the DTM port!\n");
   gr_ImageInitCMapRGB(rval, gval, bval);

   bWin = gr_topWin.bossWin;

   while (bWin != NULL) {
		cubeWin = bWin->cubeWin; 
   	while (cubeWin != NULL) {
      	dWin = cubeWin->dsplWin; 
   		while (dWin != NULL) {  /* update display windows */
	   		gr_ImageSetCMap( dWin->shell);

         	hWin = dWin->histWin;
   			while (hWin != NULL) {  /* update histogram windows */
	   			gr_ImageSetCMap( hWin->shell);
					hWin = hWin->next;
				}
				dWin = dWin->next;

			}
      cubeWin = cubeWin->next;
		}
      bWin = bWin->next;
   }

		gr_TextMsgOut("Loaded new DTM palette\n");

} /* gr_DTMpalLoad */


/* ================================================================== */

/*
* jng jan-08-91
* load SDS data from DTM port.
* patterned after td_HdfLoad().
*/

myDTMsdsLoad (sds)
A_Data_t *sds;
{
	int i,ret;
	long nsdselts;

	beep();
	gr_TextMsgOut("\nHello..a SDS just came across the DTM port!");

 	for(i=0;i<3;i++)  sds->dims[i] = 1;

	SDSgetTitle( header, sds->pathName, 80);
	SDSgetDimensions( header, &sds->rank, sds->dims, 3);
	if (sds->rank < 1 || sds->rank > 3) {
		fprintf(stderr,"bad sds dims (=%d)  from dtm!!\n",sds->rank); 
		return(-1);
	 }

	for (nsdselts = 1, i=0;i<sds->rank;i++) nsdselts *= sds->dims[i]; 
	fprintf (stderr,"nsdselts = %ld dims:", nsdselts);

	sds->data = (float32 ***)
         td_Malloc3Dfloat32 (sds->dims[0], sds->dims[1], sds->dims[2]);
	if (NULL == sds->data ) {
		td_Free3d(sds->data);
		printf("malloc err for dtm data %s\n", sds->pathName);
		return(-1);
	}

	/* gbourhis Jan 93: update to DTM 2.3			*/
	DTMreadDataset (inPort, sds->data[0][0], nsdselts , DTM_FLOAT);
 	DTMendRead(inPort);

  	sds->format = HDF;

	/* compute stats for the dtm sds dataset */

	if ( -1 == SDSgetMinMax (header, &sds->min, &sds->max)) {
		myDTMgetStats (sds);
	}

	/* --- note: GLOBALS used here!! --- */
	sds->range = sds->max - sds->min;
  	sds->rangeFrac = (float32)((float32)gr_color.nColors/sds->range);
  	sds->rangeFracSplit = (float32)((float32)gr_colorSplit.nColors/sds->range);

} /* myDTMsdsLoad */

/* &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& */

/*
* jng jan-08-91
* fill out the data structure with relevant stats
* of the received DTM SDS dataset.
* Patterned after td_HdfgetStats().
*/

myDTMgetStats (sds) 
A_Data_t	* sds;
{
	register int i,j,k;


   sds->min = sds->max = sds->data[0][0][0]; 
   for (i=0;i<sds->dims[2];i++) {
      for (j=0;j<sds->dims[1];j++) {
          for (k=0;k<sds->dims[0];k++) {
              if (sds->min > sds->data[k][j][i])
                              sds->min = sds->data[k][j][i];
              if (sds->max < sds->data[k][j][i])
                              sds->max = sds->data[k][j][i];
          }
       }
    }

}


/* &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&& */
/*
 * jng jan-08-91
 *	Open a Boss Window for a DTM dataset
 * patterned after gr_SDSLoad().
 */

myDTMbossInit (dtmname)
char * dtmname; /* name of dtm dataset */
{
	A_BossWind_t	*tmp;
	int 				i,ret,num;
	A_BossWind_t	*bwin;
	char				tname[160];
	int				match;

	sprintf(tname, "%s,DTM", dtmname);
	bwin = gr_topWin.bossWin;

	match = 0;
	while (bwin != NULL) {
		if (!strcmp(bwin->filename, tname))
		{
			match = 1;
			break;
		}		
		else 
			bwin = bwin->next;
	}

	if (match) {
		myDTMsdsLoad(bwin->data);
		myDTMupdateBoss(bwin);
		return;	
	}
	
  /*-- a new DTM dataset ---- create a new boss window for it --- */
	num = -('D'+'T'+'M'); /* special value of num signals DTM dataset */

	if (gr_topWin.numBossWins < MAX_BOSLEV_WINDS)
	{
		tmp = gr_InitBossLevel(gr_topWin.bossWin, dtmname ,gr_topLevel,
					num,&gr_topWin,HDF);
		if (tmp != NULL)
			{
				gr_topWin.bossWin = tmp;
				gr_topWin.numBossWins++;
				sprintf(msg,"Loaded 3D SDS %s.\n",dtmname);
				gr_TextMsgOut(msg);
			}
	}
	else
	{
		sprintf(msg,"Only %d Attributes window is allowed!\n", MAX_BOSLEV_WINDS);
		gr_TextMsgOut(msg);
	}

}  

#endif


