/*
 * National Center for SuperComputing Applications, University of Illinois
 *
 * This NCSA software product is public domain software.  Permission
 * is hereby granted to do whatever you like with it. Should you wish
 * to make a contribution towards the production of this software, please
 * send us your comments about your experience with the software,  why
 * you liked or disliked it, how you use it, and most importantly, how it
 * helps your work. We will receive your comments at softdev@ncsa.uiuc.edu.
 *
 * Please send bug reports to bugs@ncsa.uiuc.edu
 *
 * Author: Eng-Whatt Toh, National Center for Supercomputing Applications
 *         ewtoh@ncsa.uiuc.edu
 */

/*
 *	File:		gr_main.c
 *	Contents:	Main initialization/termination routines for graphics module
 */

#include "gr_com.h"
#include "gr_xwi.h"
#include "XDSicon.c"
#ifdef SIGCHLD
#undef SIGCHLD
#endif
#include <signal.h>

static  XtActionsRec gr_ActionsTable[] = {
	{"gr_FileDirReturn", gr_FileDirReturn},
	{"gr_FileSaveReturn", gr_FileSaveReturn},
};

static	XtResource	resources[] = {
	{ "adjustToggles","AdjustToggles", XtRBoolean, sizeof(Boolean),
	  XtOffset(ApplicationDataPtr, adjustToggles), XtRString, "FALSE"},
	{ "installCMap",  "InstallCmap",   XtRBoolean, sizeof(Boolean),
	  XtOffset(ApplicationDataPtr, installCMap), XtRString, "FALSE"},
	{ "inputFocus",   "inputFocus",    XtRBoolean, sizeof(Boolean),
	  XtOffset(ApplicationDataPtr, inputFocus), XtRString, "FALSE"},
	{ "useXImage",    "useXImage",     XtRBoolean, sizeof(Boolean),
	  XtOffset(ApplicationDataPtr, useXImage), XtRString, "FALSE"},
	{ "transpose",    "Transpose",     XtRBoolean, sizeof(Boolean),
	  XtOffset(ApplicationDataPtr, transpose), XtRString, "FALSE"},
	{ "paletteEditor",    "PaletteEditor",     XtRBoolean, sizeof(Boolean),
	  XtOffset(ApplicationDataPtr, paletteEditor), XtRString, "FALSE"},
};

static	XrmOptionDescRec	options[] = {
	{ "-adjustToggles","*adjustToggles",XrmoptionNoArg,"TRUE"},
	{ "-installCMap",  "*installCMap",  XrmoptionNoArg,"TRUE"},
	{ "-inputFocus",   "*inputFocus",   XrmoptionNoArg,"TRUE"},
	{ "-useXImage",    "*useXImage",    XrmoptionNoArg,"TRUE"},
	{ "-transpose",    "*transpose",    XrmoptionNoArg,"TRUE"},
	{ "-paletteEditor",    "*paletteEditor",    XrmoptionNoArg,"TRUE"},
};

/* gbourhis Jan 93: add fallback resources and an application
   context */
#ifdef XtSpecificationRelease
static char *fallback_resources[] = {
  "*List.Font:	fixed",
  (char *)NULL
  };

static	XtAppContext app_context;
#endif

extern	void	gr_PalInit();
extern	void	gr_ImageDefCMap();
extern	void	gr_InitTopLevel();
extern	void	td_Terminate();

/*
 * This is called by the main init function to initialize all variables
 * and other stuff pertaining to the graphics module
 */
void
gr_Init(argc,argv)
int		argc;
char	*argv[];
{
	Arg		argList[2];
	Pixmap	iconPixmap;
	extern	int	gr_CatchInterrupt();

	DBPRINTARG("GR_INIT: ac=%d \n", argc);
	{ int i; for(i=0;i<argc;i++) DBPRINT2ARGS(" av[%d] is [%s]\n", i, argv[i]); }
	gr_topLevel =
#ifdef XtSpecificationRelease
	  /* gbourhis Jan 93: use XtAppInitialize for the fallback resources */
	  XtAppInitialize(&app_context, "XDS",
			  options,XtNumber(options),&argc,argv,
			  fallback_resources,
			  (ArgList)NULL, (Cardinal)0);
#else
	  XtInitialize(argv[0], "XDS",
			  options,XtNumber(options),&argc,argv);
#endif
	if (argc==2) SETCOMMANDLINEFILE(argv[1]);

	XtGetApplicationResources(gr_topLevel, &gr_Data, resources,
		XtNumber(resources), NULL, 0);

#ifdef XtSpecificationRelease
	XtAppAddActions(app_context, gr_ActionsTable,
#else
	XtAddActions(gr_ActionsTable,
#endif
			XtNumber(gr_ActionsTable));

	if(USECOMMANDLINEFILE()) {
		 char notefile[200];
		 char *fname;
		 GETCOMMANDLINEFILE(&fname);
		 sprintf(notefile,"%s.note", fname);
	    gr_InitNotes(argv[0], gr_topLevel, notefile); /* jng  14-apr-92 */
		 }


	gr_InitTopLevel(argv[0],gr_topLevel,&gr_topWin);
	gr_topWin.fileWin = gr_InitFileLevel("XDSwindow",gr_topLevel);
	gr_topWin.numFileWins = 0;

	(*signal)(SIGINT,gr_CatchInterrupt);

	XtRealizeWidget(gr_topLevel);
	gr_FileHideLevel(gr_topWin.fileWin);

	gr_WidgetCursor(gr_topLevel,XC_draped_box);

	iconPixmap = XCreateBitmapFromData(XtDisplay(gr_topWin.shell),
		XtWindow(gr_topWin.shell), XDS_bits, XDS_width, XDS_height);
	XtSetArg(argList[0],XtNiconPixmap, iconPixmap);
	XtSetValues(gr_topLevel, argList, 1);

	gr_TextMsgOut("Product of National Center for Supercomputing Applications.\n");
	gr_TextMsgOut("Send bug reports to likkai@ncsa.uiuc.edu\n");

	gr_PalInit(gr_topWin.shell);
	gr_ImageDefCMap();

#ifdef XtSpecificationRelease
	gr_TextMsgOut("\nClick on one of the buttons to open a File Window...");
#else
	gr_TextMsgOut("\nClick on one of the buttons to open a File Window...\n");
#endif

	if (USECOMMANDLINEFILE()) {
		char * fname;
		int 	xsize, ysize, ispal;

		GETCOMMANDLINEFILE(&fname);

		if (! td_FileIsHdf(fname)) {
			printf(" [%s] is not a HDF file\n", fname); beep();
			exit(0); 
		}
		else if (td_HdfCheck(fname) != -1) {
			printf("THIS FILE [%s] IS A SDS..quit for now \n",
			       fname);
			gr_SDSLoad(NULL, gr_topWin.fileWin, NULL);
		}
		else if (td_HdfgetRasDims(fname, &xsize, &ysize, &ispal) > 0) {
			printf ("gr_main.c: calling aniload directly\n");
			gr_AniLoad(NULL, gr_topWin.fileWin, NULL);
		}
		else { 
			printf("This HDF file  has no rasters or sds. quitting.\n"); beep();
			exit(0); 
		}
	}
}


/*
 * Main event loop
 */
void
gr_ProcessLoop()
{
#ifdef XtSpecificationRelease
	XtAppMainLoop(app_context);
#else
	XtMainLoop();
#endif

	/*
	while (TRUE)
	{
		if (XtPending() == TRUE)
		{
			XEvent	report;

			XtNextEvent(&report);
			XtDispatchEvent(&report);
		}
	}
	*/
}


/*
 * Termination procedure.  Note that each termination call of a window
 * calls the termination procedures of all the child windows spawned by
 * it.
 */
void
gr_Terminate(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{

#ifdef XtSpecificationRelease
	gr_TextMsgSave();
	if (USECOMMANDLINEFILE()) /* save the notes */
	  gr_SaveNotes();	/* gbourhis, Feb 93 */
#endif

	/* Close File window if it is up */
	gr_DestroyFileLevel();

	/* Close all Boss windows.  When a boss dies, all his subordinates
	   gets killed too.  */

	while (gr_topWin.bossWin != NULL)
		gr_CloseBossLevel(gr_topWin.bossWin->shell,
			(caddr_t)gr_topWin.bossWin,(caddr_t)NULL);

	td_Terminate();
}


int
gr_CatchInterrupt(nargs,args)
int nargs;
char *args[];
{
	A_AniWind_t	*aniWin=gr_topWin.aniWin;

	while (aniWin != NULL)
	{
		if (aniWin->playStop == 0)
		{
			aniWin->playStop = 1;
			return;
		}
		aniWin = aniWin->next;
	}

	gr_TextMsgOut("X DataSlice is interrupted... goodbye.\n");
	gr_Terminate(gr_topWin.shell,(caddr_t)NULL,(caddr_t)NULL);
}
