/*
 * DSI utilities
 *
 * Copyright (C) 2010-2020 Sebastiano Vigna
 *
 *  This library is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU Lesser General Public License as published by the Free
 *  Software Foundation; either version 3 of the License, or (at your option)
 *  any later version.
 *
 *  This library is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 */

package it.unimi.dsi.util;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.io.IOException;

import org.junit.Test;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;

/**
 * @author Fabien Campagne
 * @author Sebastiano Vigna
 */
public class SemiExternalGammaListTest {

	private static InputBitStream buildInputStream(final LongList longs) throws IOException {
		final byte[] array = new byte[longs.size() * 4];
		@SuppressWarnings("resource")
		final
		OutputBitStream streamer = new OutputBitStream(array);
		for (int i = 0; i < longs.size(); i++) streamer.writeLongGamma(longs.getLong(i));
		final int size = (int)(streamer.writtenBits() / 8) + ((streamer.writtenBits() % 8) == 0 ? 0 : 1);
		final byte[] smaller = new byte[size];
		System.arraycopy(array, 0, smaller, 0, size);

		return new InputBitStream(smaller);

	}


	@Test
    public void testSemiExternalGammaListGammaCoding() throws IOException {

		final long[] longs = { 10, 300, 450, 650, 1000, 1290, 1699 };
		final LongList listLongs = new LongArrayList(longs);

		SemiExternalGammaList list = new SemiExternalGammaList(buildInputStream(listLongs), 1, listLongs.size());
		for (int i = 0; i < longs.length; ++i) {
			assertEquals(("test failed for index: " + i), longs[i], list.getLong(i));
		}

		list = new SemiExternalGammaList(buildInputStream(listLongs), 2, listLongs.size());
		for (int i = 0; i < longs.length; ++i) {
			assertEquals(("test failed for index: " + i), longs[i], list.getLong(i));
		}

		list = new SemiExternalGammaList(buildInputStream(listLongs), 4, listLongs.size());
		for (int i = 0; i < longs.length; ++i) {
			assertEquals(("test failed for index: " + i), longs[i], list.getLong(i));
		}

		list = new SemiExternalGammaList(buildInputStream(listLongs), 7, listLongs.size());
		for (int i = 0; i < longs.length; ++i) {
			assertEquals(("test failed for index: " + i), longs[i], list.getLong(i));
		}

		list = new SemiExternalGammaList(buildInputStream(listLongs), 8, listLongs.size());
		for (int i = 0; i < longs.length; ++i) {
			assertEquals(("test failed for index: " + i), longs[i], list.getLong(i));
		}
    }

	@Test
    public void testEmptySemiExternalGammaListGammaCoding() throws IOException {

		final long[] longs = {  };
		final LongList listOffsets = new LongArrayList(longs);

		new SemiExternalGammaList(buildInputStream(listOffsets), 1, listOffsets.size());
		assertTrue(true);
    }

}
