{   UTILS 4.4     E.J.Stokking    juni 1989
{
{   Utilities voor Turbo Pascal versie 4.0 of 5.0
{   Alleen voor PC's met MS-DOS of PC-DOS versie 2 of 3.
{
{   auteur:   E.J.Stokking
{             Fazantweg 3
{             9765 JL  Paterswolde
}


{$IFDEF DEBUG}
{$R+  Range checking On}
{$S+  Stack checking On}
{$D+  Debug Information On}
{$L+  Local Symbol information On}
{$ELSE}
{$R-  Range checking Off}
{$S-  Stack checking Off}
{$D-  Debug Information Off}
{$L-  Local Symbol information Off}
{$ENDIF}

{$I+  I/O checking On}
{$F-  Force Far Calls Off}
{$V+  Var-string checking Strict}
{$B-  Short Circuit Boolean evaluation}

{$IFDEF COPROCESSOR}
{$N+}
{$ELSE}
{$N-}
{$ENDIF}

unit Utils;

interface
uses Dos,Crt;

const BW40          = 0;                        {40x25 zwart/wit, CGA,EGA,VGA}
      CO40          = 1;                        {40x25 kleur, CGA,EGA,VGA}
      BW80          = 2;                        {80x25 zwart/wit, CGA,EGA,VGA}
      CO80          = 3;                        {80x25 kleur, CGA,EGA,VGA}
      Mono          = 7;                        {80x25 zwart/wit, Hercules, MDA}
      Font8x8       = $0100;                    {Add-in for ROM font (EGA,VGA)}
      Black         = 0;
      Blue          = 1;
      Green         = 2;
      Cyan          = 3;
      Red           = 4;
      Magenta       = 5;
      Brown         = 6;
      LightGray     = 7;
      DarkGray      = 8;
      LightBlue     = 9;
      LightGreen    = 10;
      LightCyan     = 11;
      LightRed      = 12;
      LightMagenta  = 13;
      Yellow        = 14;
      White         = 15;
      Blink         = 128;


type Str1           = string[1];
     Str2           = string[2];
     Str3           = string[3];
     Str4           = string[4];
     Str8           = string[8];
     Str12          = string[12];
     Str16          = string[16];
     Str24          = string[24];
     Str32          = string[32];
     Str64          = string[64];
     Str80          = string[80];
     Str128         = string[128];
     Str255         = string[255];
     StrPtr         = ^Str255;
     CharSetDef     = set of char;

     AdapterTypeDef = (None,MDA,CGA,EGAMono,EGAColor,VGAMono,
                       VGAColor,MCGAMono,MCGAColor);

     WindowPtr      = ^WindowDef;
     WindowDef      = record
                          Buffer                : Pointer;
                          BufferSize,
                          BufferStartOfs,
                          BufferLineOfs,
                          ScreenStartOfs        : word;
                          Open                  : boolean;
                          PrevOpenedWindow,
                          PrevQuickWindow       : WindowPtr; {alleen voor Quick--}
                          {--control area1--}
                          Color,
                          NormalColor,
                          DataColor,
                          DataInputColor        : byte;
                          NoScroll              : boolean;
                          {--control area1--}
                          MaxMaxL,MaxMaxC       : byte;
                          {--control area2--}
                          VideoSeg,
                          CursorOfs,
                          LineOfs,
                          UpperLeftOfs,
                          LowerRightOfs,
                          LeftOfs,RightOfs      : word;
                          CursorIsOn,
                          FileEchoEnabled       : boolean;
                          {--control area2--}
                      end;

     RefFileInfo    = ^FileInfoDef;
     FileInfoDef    = record
                          FileName    : Str12;
                          AttrStr     : Str4;
                          DateTimeInt,                 {zie DateTimeIntToStr}
                          Size        : longint;       {in bytes}
                          Next        : RefFileInfo;   {pointer naar de volgende}
                      end;

const ZeroSuppress    : boolean    = false;
      Epsilon         : real       = 1E-7;
      MaxReal         : real       = 1E37;
      RealNA          : real       = -7E36;         {real code 'not available'}
      RealER          : real       = -9E36;         {real code 'error'}
      IntNA           : longint    = -2147483646;   {integer code 'not available'}
      IntER           : longint    = -2147483647;   {integer code 'error'}
      StrNA           : Str8       = 'NA';          {string code 'not available'}
      StrER           : Str8       = 'ER';          {string code 'error'}
      StrOVF          : Str8       = '*';           {string code 'overflow'}
      ErrorFound      : boolean    = false;
      ErrorCount      : word       = 0;
      Space           : char       = ' ';
      Escape          : char       = #27;
      OpenedWindow    : WindowPtr  = nil;
      ActiveWindow    : WindowPtr  = nil;
      ThisKey         : char       = #0;
      ThisKeyCode     : word       = $0000;
      FileSpecCharSet : CharSetDef = ['A'..'Z','0'..'9','\',':','.','-','_'];
      ErrorDelay      : word       = MAXINT;        {seconds delay in errormsg}
      MultipleInput   : boolean    = false;
      ErrorColor      : byte       = $4F;

var CommandLine       : Str80;
    CheckBreak,
    CheckEof,
    DirectVideo       : boolean;
    AdapterType       : AdapterTypeDef;
    LastMode          : word absolute Crt.LastMode;  {zie Turbo manual}
    ThisTextMode      : byte absolute $0000:$0449;  {Lastmode heeft last van een bug in Turbo!}

    {----- window control area, accessed as a block in window-utilities -----}
    Color             : byte;
    TextAttr          : byte absolute Color;     {compatibel met CRT-unit}
    NormalColor,                                 {hiermee begint elk programma}
    DataColor,
    DataInputColor    : byte;
    NoScroll          : boolean;
    {----- end of window control area -----}

    CheckSnow         : boolean;
    MaxMaxL,
    MaxMaxC           : byte;
    WindMin,WindMax   : word;                    {gebruik liever MaxL en MaxC}
    SmallJobProcAddr  : Pointer;
    EchoF             : text;                    {in interface nodig voor FINAN}


function Strip(S : Str255) : Str255;
function CountChar(C : char; S : Str255) : byte;
function UpStr(S : Str255) : Str255;
function FillStr(C : char; W : byte) : Str255;
procedure DeTab(var AnyStringVar);
function FillRight(S : Str255; W : byte) : Str255;
function FillLeft(S: Str255; W : byte) : Str255;
function CenterStr(S : Str255; W : byte) : Str255;
function StrField(Delimiter : char; S : Str255; N : byte) : Str80;

function RealToInt(R : real) : longint;
function IntToReal(I : longint) : real;
function StrToReal(S : Str32) : real;
function RealToStr(R : real; W,D : shortint) : Str32;
function StrToInt(S : Str16) : longint;
function IntToStr(I : longint; W : shortint) : Str32;
function StrToChar(S : Str1) : char;
function IntToHexStr(I : longint; W : byte) : Str8;
function PtrToInt(P : pointer) : longint;
function PtrToStr(P : pointer) : Str12;

function Add(X,Y : real) : real;
function Subtract(X,Y : real) : real;
function Neg(X : real) : real;
function Multiply(X,Y : real) : real;
function Divide(X,Y : real) : real;
function Power(X,Y : real) : real;
function Zero(X : real) : boolean;
function ZeroOrNA(X : real) : boolean;
function RoundReal(R : real; D : byte) : real;

function Timer(StartTime : real) : real;
function CPUTimer(StartTime : real) : real;
function ThisDateTimeStr : Str16;
function DateTimeStrToInt(DateTimeStr : Str16) : longint;
function DateTimeIntToStr(DateTimeInt : longint) : Str16;

function GetEnvironmentStr(S : Str16) : Str80;

procedure Error(Msg1,Msg2,Msg3 : Str80);
procedure FatalError(S : Str80);
procedure CheckCtrlC;
var CheckCtrlCProcAddr : Pointer;

procedure Swap(var P1,P2; Size : word);
function IntMinMax(Min,Max,I : longint) : longint;
function RealMinMax(Min,Max,R : real) : real;
procedure Delay(MS: Word);
procedure Sound(Hz: Word);
procedure NoSound;

function CheckColor(C : byte) : byte;   {controleer kleur n.a.v. videomode}
procedure TextMode(Mode : word);        {zie Turbo manual}
procedure TextColor(Color : byte);      {voorgrondkleur instellen}
procedure TextBackground(Color : byte); {achtergrondkleur instellen}
procedure LowVideo;                     {zelfde kleur in lage intensiteit}
procedure HighVideo;                    {zelfde kleur in hoge intensiteit}
procedure NormVideo;                    {NormalColor wordt geselekteerd}
procedure ChangeColorToLC(Color,L,C : byte);
procedure AssignCrt(var F : text);
procedure Bell;
function ThisL : byte;              {regelnummer van cursor}
function ThisC : byte;              {kolomnummer van cursor}
procedure GotoC(C : byte);          {ga naar kolom C}
procedure GotoLC(L,C : byte);       {ga naar (regel,kolom)}
function WhereX : byte;             {=ThisC (standaard Turbo Pascal)}
function WhereY : byte;             {=ThisL (standaard Turbo Pascal)}
procedure GotoXY(X,Y : byte);       {=GotoLC(Y,X)  (standaard Turbo Pascal)}
function MaxL : byte;               {maximale aantal regels (window afhankelijk)}
function MaxC : byte;               {maximale aantal kolommen (window afhankelijk)}
procedure ClrScr;
procedure ClrEol;               {NB: kolom 80 wordt altijd gewist}
procedure ClrToL(L : byte);     {uitwissen t/m regel L}
procedure DelLine;
procedure InsLine;
procedure WriteInt(I : longint; W : byte);
procedure WriteReal(R : real; W,D : shortint);
procedure SetLeftMargin(C : byte);

procedure QuickOpenWindow(Title: Str64; L1,C1,L2,C2,Color : byte);
procedure QuickCloseWindow;
function NewWindow(Title : Str64; SizeL,SizeC,Color : byte) : WindowPtr;
procedure WriteToWindow(W : WindowPtr);
procedure OpenWindow(W : WindowPtr; AbsL,AbsC : byte);
procedure CloseWindow(W : WindowPtr);
procedure DisposeWindow(var W : WindowPtr);
procedure WINDOW(X1,Y1,X2,Y2 : byte);       {gebruik liever QuickOpenWindow}

function NextKeyCode : word;
procedure FlushKeyBoardBuffer;
function KeyPressed : boolean;
procedure WaitForKeyPressed;
procedure PushKeyCodeIntoKeyboardBuffer(KeyCode : word);
procedure GetKey;
function ReadKey : char;
function InKey(CharSet : CharSetDef) : char;
function InChar(CharSet : CharSetDef) : char;
function InStr(CharSet : CharSetDef; DefaultStr : Str80; W : integer) : Str80;
function InReal(Min,Max,R : real; W : byte; Dec : shortint) : real;
function InInt(Min,Max,I : longint; W : byte) : longint;
function InChoice(ChoiceStr : Str255; DefaultChoice : byte) : byte;

procedure GetStr(var S; CharSet : CharSetDef; W : byte);
procedure GetReal(var R : real; Min,Max : real; W : byte; Dec : shortint);
procedure GetInt(var I : longint; Min,Max : longint; W : byte);
procedure GetChoice(var B : byte; ChoiceStr : Str255);
procedure GetNow;

function FreeDiskSpace(Drive : char) : longint;
function TotalDiskSpace(Drive : char) : longint;
function ClusterSize(Drive : char) : longint;
function ThisPath : Str64;
function ChangePath(Path : Str64) : boolean;
function MakeDir(DirName : Str64) : boolean;
function RemoveDir(DirName : Str64) : boolean;
function SizeOfFile(FileSpec : Str64) : longint;
function DeleteFile(FileSpec : Str64) : boolean;
function RenameFile(OldFileSpec, NewFileSpec : Str64): boolean;
function ExtractFileName(FileSpec : Str64) : Str12;
function ExtractPath(FileSpec : Str64) : Str64;
function ExtractDrive(FileSpec : Str64) : char;
function MakeFileSpec(Path : Str64; FileName : Str12) : Str64;
function FindPath(FileSpec : Str64) : Str64;
function ExistFile(FileSpec : Str64) : boolean;
function OpenInputTextFile(var InF : text; FileSpec : Str64) : boolean;
function OpenOutputTextFile(var OutF : text; FileSpec : Str64) : boolean;
function OpenAppendTextFile(var OutF : text; FileSpec : Str64) : boolean;
function EchoToFile(FileSpec : Str64) : boolean;
procedure EndEchoToFile;
function SetFileDateTime(FileSpec : Str64; DateTimeInt : longint) : boolean;
function GetFileDateTime(FileSpec : Str64) : longint;
function GetFileAttr(FileSpec : Str64) : Str8;
function SetFileAttr(FileSpec : Str80; Attr : Str8) : boolean;
function BuildFileInfoList(FileSpecMask : Str80; AttrStr : Str4) : RefFileInfo;
procedure SortFileInfoList(var FirstFileInfo : RefFileInfo);
procedure DisposeFileInfoList(var FirstFileInfo : RefFileInfo);


implementation

type PtrRec         = record
                          Ofs,Seg : word;
                      end;
     GetTypeDef     = (StrGet,IntGet,RealGet,ChoiceGet);
     RefGet         = ^GetDef;
     GetDef         = record
                          Suc,Pred     : RefGet;
                          L,C,W        : byte;
                          Dec          : shortint;
                          VarPtr       : Pointer;
                          GetType      : GetTypeDef;
                          Min,Max      : real;
                          CharSet      : CharSetDef;
                          ChoiceStrPtr : StrPtr;
                      end;


const FirstGet          : RefGet    = nil;
      LastGet           : RefGet    = nil;
      UserWaitTime      : real      = 0.0;
      LeftMarginOfs     : word      = 0;
      HighLight         : boolean   = true;
      LCDHighColor      : byte      = $0F;

      {----- window control area2, accessed as block in window-utilities -----}
      VideoSeg          : word      = $B800;    {reinitialized if VideoMode=7}
      CursorOfs         : word      = 0;        {cursor position}
      LineOfs           : word      = 160;      {offset of next videoline}
      UpperLeftOfs      : word      = 0;        {offset of upperleft corner of window}
      LowerRightOfs     : word      = 3998;     {offset of lowerright corner of window}
      LeftOfs           : word      = 0;        {offset of first char on current line}
      RightOfs          : word      = 158;      {offset of last char on current line}
      CursorIsOn        : boolean   = false;
      FileEchoEnabled   : boolean   = false;
      {----- end of window control area2 -----}

var OrgExitProc       : Pointer;
    KeyboardState     : byte absolute $0000:$0417;
    OrgKeyboardState  : byte;
    OrgTextMode       : byte;   {oorspronkelijke text mode}


procedure SmallJob; inline($FF/$1E/SmallJobProcAddr);
procedure UserCheckCtrlC; inline($FF/$1E/CheckCtrlCProcAddr);

{$IFDEF sdump}    {mogelijkheid om eenvoudig screendumps te maken}
procedure DumpScreenBin; forward;
procedure DumpScreenASCII; forward;
{$ENDIF}


procedure Swap(var P1,P2; Size : word);
{ Swaps the value of two variables, e.g.: Swap(A,B,SIZEOF(A));   }
{ See Charles C.Edwards: Advanced Techniques in Turbo Pascal p67 }
begin
    inline($1E/             {         PUSH    DS          }
           $C5/$B6/P1/      {         LDS     SI,P1[BP]   }
           $C4/$BE/P2/      {         LES     DI,P2[BP]   }
           $8B/$8E/Size/    {         MOV     CX,Size[BP] }
           $E3/$0A/         {         JCXZ    L2          }
           $FC/             {         CLD                 }
           $26/$8A/$05/     { L1:     MOV     AL,ES:[DI]  }
           $86/$04/         {         XCHG    [SI],AL     }
           $46/             {         INC     SI          }
           $AA/             {         STOSB               }
           $E2/$F7/         {         LOOP    L1          }
           $1F);            { L2:     POP     DS          }
end;


function IntMinMax(Min,Max,I : longint) : longint;
begin
    if I<=Min then IntMinMax:=Min else
    if I>=Max then IntMinMax:=Max else IntMinMax:=I;
end;


function RealMinMax(Min,Max,R : real) : real;
begin
    if R<=Min then RealMinMax:=Min else
    if R>=Max then RealMinMax:=Max else RealMinMax:=R;
end;


procedure StripVar(var AnyStringVar);
{strips leading and trailing blanks from a string variable}
    var S      : Str255 absolute AnyStringVar;
        Length : byte absolute S;
        P      : byte;
begin
    P := 1;
    while S[Length]=Space do DEC(Length);
    if Length>0 then while S[P]=Space do INC(P);
    Length := Length-P+1;
    MOVE(S[P],S[1],Length);
end;


function Strip(S : Str255) : Str255;
{slower but often more convenient than StripVar}
begin
    StripVar(S);
    Strip := S;
end;


function CountChar(C : char; S : Str255) : byte;
{counts number of characters C in string S}
    var N,P   : byte;
        Blank : char;
begin
    if C=#0 then Blank:=#1 else Blank:=#0;
    P := POS(C,S);
    N := 0;
    while P>0 do
    begin
        INC(N);
        S[P] := Blank;
        P := POS(C,S);
    end;
    CountChar := N;
end;


procedure UpStrVar(var S);
{returns string S in uppercase}
{see Turbo Pascal 3.0 Manual, p213}
begin
    inline($C4/$BE/S/               {         LES     DI,S[BP]             }
           $26/$8A/$0D/             {         MOV     CL,ES:[DI]           }
           $FE/$C1/                 {         INC     CL                   }
           $FE/$C9/                 { L1:     DEC     CL                   }
           $74/$13/                 {         JZ      L2                   }
           $47/                     {         INC     DI                   }
           $26/$80/$3D/$61/         {         CMP     ES:BYTE PTR [DI],'a' }
           $72/$F5/                 {         JB      L1                   }
           $26/$80/$3D/$7A/         {         CMP     ES:BYTE PTR [DI],'z' }
           $77/$EF/                 {         JA      L1                   }
           $26/$80/$2D/$20/         {         SUB     ES:BYTE PTR [DI],20H }
           $EB/$E9);                {         JMP     SHORT L1             }
                                    { L2:                                  }
end;


function UpStr(S : Str255) : Str255;
{slower but often more convenient than UpStrVar}
begin
    UpStrVar(S);
    UpStr := S;
end;


function FillStr(C : char; W : byte) : Str255;
{returns a string with W characters C}
    var S      : Str255;
        Length : byte absolute S;
begin
    FILLCHAR(S[1],W,C);
    Length := W;
    FillStr := S;
end;


procedure DeTab(var AnyStringVar);
{removes tabs from string}
    var S : Str255 absolute AnyStringVar;
        P : byte;
begin
    P := POS(^I,S);
    while P>0 do
    begin
        S[P] := Space;
        INSERT(FillStr(Space,(256-P) mod 8),S,P);
        P := POS(^I,S);
    end;
end;


function FillRight(S : Str255; W : byte) : Str255;
{left-align S, total width is W}
    var Length : byte absolute S;   {same as LENGTH(S)}
begin
    if Length<W then FILLCHAR(S[Length+1],W-Length,Space);
    if W<>0 then Length:=W;
    FillRight := S;
end;


function FillLeft(S: Str255; W : byte) : Str255;
{right-align S, total width is W}
    var Length : byte absolute S;
begin
    if Length<W then
    begin
        MOVE(S[1],S[W-Length+1],Length);
        FILLCHAR(S[1],W-Length,Space);
    end;
    if W<>0 then Length:=W;
    FillLeft := S;
end;


function CenterStr(S : Str255; W : byte) : Str255;
    var Length : byte absolute S;
        N      : byte;
begin
    if Length<W then
    begin
        N := ((W-Length) div 2);
        MOVE(S[1],S[N+1],Length);
        FILLCHAR(S[1],N,Space);
        FILLCHAR(S[Length+N+1],W-Length-N,Space);
    end;
    if W<>0 then Length:=W;
    CenterStr := S;
end;


function GetEnvironmentStr(S : Str16) : Str80;
{reads MS-DOS environmentstring}
    type EnvDef = array[1..160] of char;
    var Length : byte absolute S;
        EnvPtr : ^EnvDef;
        P      : byte;
begin
    EnvPtr := PTR(MEMW[PREFIXSEG:$002C],$0000);
    P := POS(UpStr(S)+'=',EnvPtr^);
    if (P=0) or (S='') then GetEnvironmentStr:='' else
        GetEnvironmentStr := COPY(EnvPtr^,P+Length+1,POS(#0,COPY(EnvPtr^,P+Length,128))-2);
end;


function StrField(Delimiter : char; S : Str255; N : byte) : Str80;
{returns Nth field in string S, delimited with Delimiter}
    var I,P,W : byte;
begin
    P:=1; W:=0; I:=0;
    repeat
        P := P+W;
        W := POS(Delimiter,COPY(S,P,255));
        INC(I);
    until (W=0) or (I=N);
    if I<N then StrField:='' else
    if W=0 then StrField:=COPY(S,P,255) else StrField:=COPY(S,P,W-1);
end;


function RoundReal(R : real; D : byte) : real;
{rounds R with D decimals}
    var S        : Str32;
        Result   : real;
        ErrorPos : integer;
begin
    if R=RealER then RoundReal:=RealER else
    if R=RealNA then RoundReal:=RealNA else
    begin
        STR(R:0:D,S);
        VAL(S,Result,ErrorPos);
        if ErrorPos=0 then RoundReal:=Result else RoundReal:=RealER;
    end;
end;


function Timer(StartTime : real) : real;
{returns time since StartTime}
    var Clock        : longint absolute $0000:$046C;
        MidnightPass : byte absolute $0000:$0470;
        Result       : real;
begin
    Result := Clock/18.206481933;
    if MidnightPass<>0 then Result:=Result+1573040;
    Timer := Result-StartTime;
end;


function CPUTimer(StartTime : real) : real;
{returns cputime (=elapsedtime-userinputtime) since StartTime}
begin
    CPUTimer := Timer(0) - UserWaitTime - StartTime;
end;


function DateTimeStrToInt(DateTimeStr : Str16) : longint;
    var DT        : DateTime;   {predefined in DOS-unit}
        ErrorCode : integer;
        Result    : longint;
begin
    StripVar(DateTimeStr);
    if DateTimeStr='' then DateTimeStrToInt:=IntNA else
    if DateTimeStr=StrNA then DateTimeStrToInt:=IntNA else
    if DateTimeStr=StrER then DateTimeStrToInt:=IntER else
    begin
        if DateTimeStr[1]=Space then DateTimeStr[1]:='0';
        if DateTimeStr[3]<>'-' then INSERT('0',DateTimeStr,1);
        if DateTimeStr[6]<>'-' then INSERT('0',DateTimeStr,4);
        FILLCHAR(DT,SIZEOF(DT),0);
        VAL(COPY(DateTimeStr,1,2),DT.Day,ErrorCode);
        if ErrorCode<>0 then begin DateTimeStrToInt:=IntER; EXIT end;
        VAL(COPY(DateTimeStr,4,2),DT.Month,ErrorCode);
        if ErrorCode<>0 then begin DateTimeStrToInt:=IntER; EXIT end;
        VAL(COPY(DateTimeStr,7,2),DT.Year,ErrorCode);
        if ErrorCode<>0 then begin DateTimeStrToInt:=IntER; EXIT end;
        DT.Year := DT.Year+1900;
        if LENGTH(DateTimeStr)>10 then
        begin
            VAL(COPY(DateTimeStr,11,2),DT.Hour,ErrorCode);
            if ErrorCode<>0 then begin DateTimeStrToInt:=IntER; EXIT end;
            VAL(COPY(DateTimeStr,14,2),DT.Min,ErrorCode);
            if ErrorCode<>0 then begin DateTimeStrToInt:=IntER; EXIT end;
        end;
        PACKTIME(DT,Result);
        if (Result shr 16)=$0021 then Result:=IntNA;   {1-1-80}
        DateTimeStrToInt := Result;
    end;
end;


function DateTimeIntToStr(DateTimeInt : longint) : Str16;
    var DT     : DateTime;  {predefined in DOS-unit}
        Result : Str16;
begin
    if DateTimeInt=IntNA then DateTimeIntToStr:=StrNA else
    if DateTimeInt=IntER then DateTimeIntToStr:=StrER else
    begin
        UNPACKTIME(DateTimeInt,DT);
        Result := IntToStr(DT.Day,2)+'-'+
                  IntToStr(DT.Month,2)+'-'+
                  IntToStr(DT.Year-1900,2)+Space+Space+
                  IntToStr(DT.Hour,2)+':'+
                  IntToStr(DT.Min,2);
        if Result[4]=Space then Result[4]:='0';
        if Result[11]=Space then Result[11]:='0';
        if Result[14]=Space then Result[14]:='0';
        DateTimeIntToStr := Result;
    end;
end;


function ThisDateTimeStr : Str16;
{returns date and time from system clock: DD-MM-YY  HH:MM}
    var Reg    : Registers;
        DT     : DateTime;  {predefined in DOS-unit}
        Result : longint;
begin
    FILLCHAR(DT,SIZEOF(DT),0);
    Reg.AH := $2A;
    MSDOS(Reg);
    DT.Day := Reg.DL;
    DT.Month := Reg.DH;
    DT.Year := Reg.CX;
    Reg.AH := $2C;
    MSDOS(Reg);
    DT.Hour := Reg.CH;
    DT.Min := Reg.CL;
    PACKTIME(DT,Result);
    ThisDateTimeStr := DateTimeIntToStr(Result);
end;


procedure Error(Msg1,Msg2,Msg3 : Str80);
    var L,C,HorSize,VerSize : byte;
        OrgLeftMarginOfs    : word;
        StartTime           : real;
begin
    Bell;
    OrgLeftMarginOfs := LeftMarginOfs;
    LeftMarginOfs := 0;
    ErrorFound := true;
    ErrorCount := ErrorCount+1;
    if Msg2='' then Swap(Msg2,Msg3,SIZEOF(Msg2));
    if Msg3<>'' then VerSize:=3 else
    if Msg2<>'' then VerSize:=2 else VerSize:=1;
    HorSize := LENGTH(Msg1);
    if HorSize<LENGTH(Msg2) then HorSize:=LENGTH(Msg2);
    if HorSize<LENGTH(Msg3) then HorSize:=LENGTH(Msg3);
    if ThisL>12 then L:=3 else L:=12;
    C := 4;
    QuickOpenWindow('error',L,C,L+1+VerSize,C+1+HorSize,ErrorColor);
    NoScroll := true;
    WRITELN(Msg1);
    if Msg2<>'' then WRITELN(Msg2);
    if Msg3<>'' then WRITELN(Msg3);
    FlushKeyboardBuffer;
    StartTime := Timer(0);
    repeat SmallJob until (Timer(StartTime)>ErrorDelay) or KEYPRESSED;
    UserWaitTime := UserWaitTime + Timer(StartTime);
    FlushKeyboardBuffer;
    QuickCloseWindow;
    LeftMarginOfs := OrgLeftMarginOfs;
end;


procedure FatalError(S : Str80);
begin
    WriteToWindow(nil);
    if MAXAVAIL<1000 then RELEASE(HEAPORG);
    {griezelig indien exitprocedures heap gebruiken, nodig om ruimte te maken voor errorwindow}
    Error('Fatal error',S,'program aborted');
    HALT;
end;


{$F+} procedure IgnoreSmallJob; {$F-}
begin
end;


procedure CheckCtrlC;
begin
    UserCheckCtrlC;
end;


{$F+} procedure MyCheckCtrlC; {$F-}
    var BufferHeadOfs       : word absolute $0040:$001A;
        BufferTailOfs       : word absolute $0040:$001C;
        BufferLastOfs       : word;
        StartTime           : real;
        OrgSmallJobProcAddr : pointer;
begin
    OrgSmallJobProcAddr := SmallJobProcAddr;
    SmallJobProcAddr := @IgnoreSmallJob;        {i.v.m. FINAN}
    if BufferHeadOfs<>BufferTailOfs then        {keypressed}
    begin
        if BufferTailOfs=$001E then BufferLastOfs:=$003C else BufferLastOfs:=BufferTailOfs-2;
{$IFDEF sdump}
        if MEMW[$0040:BufferLastOfs]=$2004 then  {ctrl-D}
        begin
            BufferHeadOfs := BufferTailOfs;
            DumpScreenBin;
        end else
        if MEMW[$0040:BufferLastOfs]=$1E01 then  {ctrl-A}
        begin
            BufferHeadOfs := BufferTailOfs;
            DumpScreenASCII;
        end else
{$ENDIF}
        if MEMW[$0040:BufferLastOfs]=$2E03 then  {ctrl-C is last pressed key}
        begin
            BufferHeadOfs := BufferTailOfs;     {flush keyboard buffer}
            Bell;
            {be sure enough memory on heap is available for window...}
            QuickOpenWindow('ctrl-C',10,30,12,56,ErrorColor);
            WRITE(' terminate program? ');
            if InChoice('yes|no',2)=1 then begin QuickCloseWindow; HALT end;
            QuickCloseWindow;
        end else
        if MEMW[$0040:BufferLastOfs]=$1F13 then  {ctrl-S is last pressed key}
        begin
            BufferHeadOfs := BufferTailOfs;
            {hier niet WaitForKeyPressed want daarbinnen wordt CheckCtrlC dan recursief aangeroepen}
            StartTime := Timer(0);
            repeat SmallJob until BufferHeadOfs<>BufferTailOfs;  {wait for key}
            UserWaitTime := UserWaitTime + Timer(StartTime);
            BufferHeadOfs := BufferTailOfs;
        end;
    end;
    SmallJobProcAddr := OrgSmallJobProcAddr;
end;


procedure Delay(MS: Word);
begin
    CRT.DELAY(MS);
end;


procedure Sound(Hz: Word);
begin
    CRT.SOUND(Hz);
end;


procedure NoSound;
begin
    CRT.NOSOUND;
end;


function Zenith : boolean;
    var Manufacturer : array[1..3] of char absolute $F000:$800C;
begin
    Zenith := Manufacturer='ZDS';
end;


function RealToInt(R : real) : longint;
begin
    if R=RealNA then RealToInt:=IntNA else
        if (R=RealER) or (ABS(R)>MAXLONGINT) then RealToInt:=IntER else
            RealToInt:=ROUND(R);
end;


function IntToReal(I : longint) : real;
begin
    if I=IntNA then IntToReal:=RealNA else
        if I=IntER then IntToReal:=RealER else
            IntToReal:=I;
end;


function StrToReal(S : Str32) : real;
    var Length   : byte absolute S;
        Result   : real;
        ErrorPos : integer;
begin
    StripVar(S);
    if S='' then
    begin
        if ZeroSuppress then StrToReal:=0 else StrToReal:=RealNA;
    end else
    if S=StrNA then StrToReal:=RealNA else
    begin
        VAL(S,Result,ErrorPos);
        if ErrorPos=0 then StrToReal:=Result else
        if ErrorPos<=Length then
        begin
            if S[ErrorPos]=',' then
            begin
                S[ErrorPos] := '.';
                StrToReal := StrToReal(S);  {recursion}
            end else StrToReal:=RealER;
        end;
    end;
end;


function RealToStr(R : real; W,D : shortint) : Str32;
    var Result   : Str64;       {MaxReal=1E37}
        Length   : byte absolute Result;
        WW,DD    : shortint;
begin
    if W>=0 then WW:=W else WW:=0; {niet opvullen}
    if D>=0 then DD:=D else DD:=9; {aut.decimalen}
    if R=RealNA then begin RealToStr:=FillLeft(StrNA,WW); EXIT end;
    if R=RealER then begin RealToStr:=FillLeft(StrER,WW); EXIT end;
    if ZeroSuppress and (ABS(R)<Epsilon) then
    begin
        RealToStr := FillStr(Space,WW);
        EXIT;
    end;
    STR(R:WW:DD,Result);
    if (D<0) {and (POS('.',Result)<>0)} then      {overbodige decimalen afpellen}
    begin
        while Result[Length]='0' do DEC(Length);
        if Result[Length]='.' then DEC(Length);
    end;
    if (Length=W) or (W<0) and (Length<=-W) or (W=0) then RealToStr:=Result else
    if Length<W then RealToStr:=FillLeft(Result,W) else
    if D>=0 then RealToStr:=FillLeft(StrOVF,WW) else
    begin
        DD := Length-POS('.',Result);
        if DD=Length then DD:=-1;
        if Length-DD-1>ABS(W) then RealToStr:=FillLeft(StrOVF,WW) else
        begin
            if Length-DD>ABS(W) then DD:=0 else DD:=DD-(Length-ABS(W));
            STR(R:WW:DD,Result);
            RealToStr := Result;
        end;
    end;
end;


function StrToInt(S : Str16) : longint;
    var Length   : byte absolute S;
        Result   : longint;
        ErrorPos : integer;
begin
    StripVar(S);
    if S='' then
    begin
        if ZeroSuppress then StrToInt:=0 else StrToInt:=IntNA;
    end else
    if S=StrNA then StrToInt:=IntNA else
    begin
        VAL(S,Result,ErrorPos);
        if ErrorPos=0 then StrToInt:=Result else StrToInt:=IntER;
    end;
end;


function IntToStr(I : longint; W : shortint) : Str32;
{indien W<0 dan wordt het getal links met nullen i.p.v. spaties aangevuld}
    var Result : Str32;
        Length : byte absolute Result;
begin
    if I=IntNA then Result:=StrNA else
    if I=IntER then Result:=StrER else
    if ZeroSuppress and (I=0) then Result:=FillStr(Space,ABS(W)) else
        STR(I:ABS(W),Result);
    if Length<ABS(W) then Result:=FillLeft(Result,ABS(W)) else
    if (Length>ABS(W)) and (W<>0) then Result:=FillLeft(StrOVF,ABS(W)); {overflow}
    if W<0 then
    begin
        W := 1;
        while (W<=Length) and (Result[W]=Space) do
        begin
            Result[W] := '0';
            INC(W);
        end;
    end;
    IntToStr := Result;
end;


function StrToChar(S : Str1) : char;
    var LengthS : byte absolute S;
begin
    if LengthS=0 then StrToChar:=#0 else StrToChar:=S[1];
end;


function IntToHexStr(I : longint; W : byte) : Str8;
    type Bytes = array[1..4] of byte;
    function ByteToHexStr(B : byte) : Str2;
        function NybbleToHexStr(N : byte) : Str1;
        begin
            if N>9 then NybbleToHexStr:=CHR(55+N) else NybbleToHexStr:=CHR(48+N);
        end;
    begin
        ByteToHexStr := NybbleToHexStr(B shr 4) + NybbleToHexStr(B and $F);
    end;
begin
    IntToHexStr := FillLeft(COPY(ByteToHexStr(Bytes(I)[4])+ByteToHexStr(Bytes(I)[3])+
                            ByteToHexStr(Bytes(I)[2])+ByteToHexStr(Bytes(I)[1]),
                            IntMinMax(1,8,8-W+1),IntMinMax(0,8,W)),W);
end;


function PtrToInt(P : pointer) : longint;
{use this function to calculate number of bytes between to memorylocations}
    var Result : longint;
begin
    Result := PtrRec(P).Seg;
    PtrToInt := (Result shl 4) + PtrRec(P).Ofs;
end;


function PtrToStr(P : pointer) : Str12;
begin
    PtrToStr := IntToHexStr(PtrRec(P).Seg,4)+':'+IntToHexStr(PtrRec(P).Ofs,4);
end;


function Zero(X : real) : boolean;      {RealNA is not zero!}
begin
    Zero := ABS(X)<Epsilon;   {ABS(RealER)>Epsilon}
end;


function ZeroOrNA(X : real) : boolean;
begin
    ZeroOrNA := (X=RealNA) or (ABS(X)<Epsilon);   {ABS(RealER)>Epsilon}
end;


function Add(X,Y : real) : real;
begin
    if (X=RealER) or (Y=RealER) then Add:=RealER else
    if X=RealNA then Add:=Y else
    if Y=RealNA then Add:=X else
    if MaxReal-ABS(Y)>ABS(X) then Add:=X+Y else Add:=RealER;
end;


function Subtract(X,Y : real) : real;
begin
    if (X=RealER) or (Y=RealER) then Subtract:=RealER else
    if Y=RealNA then Subtract:=X else
    if X=RealNA then Subtract:=-Y else
    if MaxReal-ABS(Y)>ABS(X) then Subtract:=X-Y else Subtract:=RealER;
end;


function Neg(X : real) : real;
begin
    if X=RealER then Neg:=RealER else
    if X=RealNA then Neg:=RealNA else Neg:=-X;
end;


function Multiply(X,Y : real) : real;
begin
    if (X=RealER) or (Y=RealER) then Multiply:=RealER else
    if (X=RealNA) or (Y=RealNA) then Multiply:=RealNA else   {!! o.a. nodig voor FINAN !!}
    if ABS(Y)<=1 then Multiply:=X*Y else
    if MaxReal/ABS(Y)>ABS(X) then Multiply:=X*Y else Multiply:=RealER;
end;


function Divide(X,Y : real) : real;
begin
    if (X=RealER) or (Y=RealER) or ZeroOrNA(Y) then Divide:=RealER else
    if X=RealNA then Divide:=RealNA else
    if ABS(Y)>=1 then Divide:=X/Y else
    if MaxReal*ABS(Y)>ABS(X) then Divide:=X/Y else Divide:=RealER;
end;


function Power(X,Y : real) : real;
{ calculates X^Y }
    const LnMaxReal = 87.498234;
    var LnX,MaxY    : real;
begin
    if (X=RealER) or (Y=RealER) then Power:=RealER else
    if (X=RealNA) or (Y=RealNA) then Power:=RealNA else
    if Zero(X) and (Y>=Epsilon) then Power:=0 else
    if X<Epsilon then Power:=RealER else
    if X<(1+Epsilon) then Power:=EXP(Y*LN(X)) else
    begin
        LnX := LN(X);
        MaxY := LnMaxReal/LnX;              {X=1 --> LnX=0}
        if Y<-MaxY then Power:=0 else
        if Y>MaxY then Power:=RealER else
        Power:=EXP(Y*LnX);
    end;
end;



{$I UTILS.INC}     {otherwise UTILS.PAS is too big for editor}


{$F+} procedure TerminationProc; {$F-}
{this is the exit procedure}
    var Msg : Str80;
begin
    EXITPROC := OrgExitProc;
    WriteToWindow(nil);
    if ERRORADDR<>nil then
    begin
        case EXITCODE of
              1..99:   Msg:='MS-DOS error';
            101:       Msg:='Disk full';
            100..149:  Msg:='I/O error';
            159:       Msg:='Printer not ready';
            150..158,
            160..199:  Msg:='Critical runtime error';
            201:       Msg:='Range check error';
            203:       Msg:='Memory overflow';
            204:       {if PtrRec(FREEPTR).Ofs<=$10000-FREEMIN then}
{SJW!!!}                   Msg:='Fragmented heap, unable to expand free list'
                       {else Msg:='Invalid pointer operation'};
            200,
            205..207:  Msg:='Floating point error';
            else       Msg:='Runtime error';
        end;
        RELEASE(HEAPORG);  {release entire heap to make space for errorwindow}
        Error(Msg,
              'at address '+PtrToStr(ERRORADDR)+', error number '+IntToStr(EXITCODE,0),
              'program aborted');
    end;
    KeyboardState := (OrgKeyboardState and $F0) + (KeyboardState and $0F);  {op verzoek, i.v.m. HISAN na ctrl-C}
    {$I-} CLOSE(EchoF); {$I+}
    if IORESULT<>0 then ;
    CRT.GOTOXY(ThisC,ThisL);
    if ThisTextMode<>OrgTextMode then TEXTMODE(OrgTextMode);
    CursorOn;
end;

var S : Str4;

begin
    HighLight := UpStr(GetEnvironmentStr('HIGHLIGHT'))<>'OFF';
    S := GetEnvironmentStr('LCDHIGH');
    if S<>'' then
    begin
        if S[1]<>'$' then S:='$'+S;
        LCDHighColor := StrToInt(S) mod 128;
    end;
    OrgTextMode := ThisTextMode;
    OrgExitProc := EXITPROC;
    EXITPROC := @TerminationProc;
    SmallJobProcAddr := @IgnoreSmallJob;
    CheckCtrlCProcAddr := @MyCheckCtrlC;
    MOVE(MEM[PREFIXSEG:$0080],CommandLine,SIZEOF(CommandLine));
    StripVar(CommandLine);
    AdapterType := GetAdapterType;
    {altijd TEXTMODE aanroepen:}
    if not (ThisTextMode in [BW80,CO80,MONO]) then TEXTMODE(BW80) else TEXTMODE(ThisTextMode);
    CheckSnow := not Zenith and (AdapterType=CGA);
    NoScroll := false;
    GotoLC(CRT.WHEREY,CRT.WHEREX);
    CursorOff;
    FlushKeyboardBuffer;
    OrgKeyboardState := KeyboardState;
    KeyboardState := KeyboardState and $9F;  {capslockoff, numlockoff}
    MEM[$0000:$0470] := 0;  {midnightpass of timer}
    UserWaitTime     := 0;
    ASSIGNCRT(INPUT);  RESET(INPUT);
    ASSIGNCRT(OUTPUT); REWRITE(OUTPUT);
end.
