% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki_utils.R
\name{w_query}
\alias{w_query}
\title{Response from Wikidata Query Service}
\usage{
w_query(sparql_query, format = "csv", method = "GET", limitRequester = FALSE)
}
\arguments{
\item{sparql_query}{A string with the query in SPARQL language.}

\item{format}{A string with the query response format. Mandatory.
See https://www.mediawiki.org/wiki/Wikidata_Query_Service/User_Manual#SPARQL_endpoint.
Only  'json', 'xml' or 'csv' formats are allowed, default 'csv'.}

\item{method}{The method used in the httr request, GET or POST, mandatory.
Default 'GET'.}

\item{limitRequester}{If True, uses a rate limiter to limit the requests.}
}
\value{
The response in selected format or NULL on errors.
}
\description{
Retrieve responses from Wikidata Query Service (WDQS). Uses a rate limiter if
param limitRequester = TRUE.
}
\author{
Angel Zazo, Department of Computer Science and Automatics, University of Salamanca
}
