% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Gumbel}
\alias{Gumbel}
\alias{r_gumbel}
\alias{d_gumbel}
\alias{p_gumbel}
\alias{q_gumbel}
\title{Gumbel Distribution}
\usage{
r_gumbel(n, mu = 0, sigma = 1)

d_gumbel(x, mu = 0, sigma = 1, log = FALSE)

p_gumbel(q, mu = 0, sigma = 1, lower = TRUE, log = FALSE)

q_gumbel(p, mu = 0, sigma = 1, lower = TRUE, log = FALSE)
}
\arguments{
\item{n}{Number of draws.}

\item{mu}{Location parameter.}

\item{sigma}{Scale parameter.}

\item{x}{Vector; argument of density.}

\item{log}{Logical; if \code{TRUE}, probabilities \eqn{p} are given as
\eqn{\log(p)}.}

\item{q}{Vector; argument of quantile function.}

\item{lower}{Logical; if \code{TRUE} (default), probabilities are
\eqn{P[X \leq x]} otherwise, \eqn{P[X > x]}.}

\item{p}{Vector; argument of cumulative distribution function.}
}
\value{
\code{d_gumbel} computes the density, \code{r_gumbel} generates random deviates,
\code{p_gumbel} computes the CDF, and \code{q_gumbel} computes quantiles. A vector is
returned by each.
}
\description{
Functions for the Gumbel distribution with density
\deqn{
f(x \mid \mu, \sigma) =
\frac{1}{\sigma}
\exp\{ -\{ (x - \mu) / \sigma + e^{-(x - \mu) / \sigma} \} \}
}
}
\examples{
mu = 1
sigma = 2
x = r_gumbel(100000, mu, sigma)
xx = seq(min(x), max(x), length.out = 100)

plot(density(x))
lines(xx, d_gumbel(xx, mu, sigma), lty = 2, col = "blue", lwd = 2)

plot(ecdf(x))
lines(xx, p_gumbel(xx, mu, sigma), lty = 2, col = "blue", lwd = 2)

pp = seq(0, 1, length.out = 102) |> head(-1) |> tail(-1)
qq = quantile(x, probs = pp)
plot(pp, qq)
lines(pp, q_gumbel(pp, mu, sigma), lty = 2, col = "blue", lwd = 2)

}
