% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_clustering.R
\name{compute_metric}
\alias{compute_metric}
\title{Compute an internal evaluation metric for clustered data}
\usage{
compute_metric(dmat, clusters, metric_name, max_k = 14)
}
\arguments{
\item{dmat}{distance matrix output of \code{\link[=compute_dmat]{compute_dmat()}} or \code{\link[stats:dist]{stats::dist()}}}

\item{clusters}{output of \code{\link[=compute_clusters]{compute_clusters()}} or \code{\link[fastcluster:hclust]{fastcluster::hclust()}}}

\item{metric_name}{"silhouette" or "dunn"}

\item{max_k}{maximum number of clusters to cut using \code{\link[dendextend:cutree-methods]{dendextend::cutree()}}. Default is 14.}
}
\value{
a data frame with columns \code{k} and \code{score}
}
\description{
Metric will be computed from 2 to max_k clusters. Note that the row number in results will be different from k.
}
\examples{
data_to_cluster <- iris[c("Petal.Length", "Sepal.Length")]
dmat <- compute_dmat(data_to_cluster, "euclidean", TRUE)
clusters <- compute_clusters(dmat, "complete")
compute_metric(dmat, clusters, "dunn")
}
