% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{v_bar}
\alias{v_bar}
\title{Create a Bar Chart}
\usage{
v_bar(
  vc,
  mapping = NULL,
  data = NULL,
  name = NULL,
  stack = FALSE,
  percent = FALSE,
  direction = c("vertical", "horizontal"),
  ...,
  serie_id = NULL,
  data_id = NULL,
  data_specs = list()
)
}
\arguments{
\item{vc}{A chart initialized with \code{\link[=vchart]{vchart()}}.}

\item{mapping}{Default list of aesthetic mappings to use for chart.}

\item{data}{Default dataset to use for chart. If not already
a \code{data.frame}, it will be coerced to with \code{as.data.frame}.}

\item{name}{Name for the serie, only used for single serie (no \code{color}/\code{fill} aesthetic supplied).}

\item{stack}{Whether to stack the data or not (if \code{fill} aesthetic is provided).}

\item{percent}{Whether to display the data as a percentage.}

\item{direction}{The direction configuration of the chart: \code{"vertical"} (default) or \code{"horizontal"}.}

\item{...}{Additional parameters for the serie.}

\item{data_id, serie_id}{ID for the data/serie, can be used to further customize the chart with \code{\link[=v_specs]{v_specs()}}.}

\item{data_specs}{Additional options for the data,
see \href{https://visactor.io/vchart/option/commonChart#data(IDataType\%7CIDataType\%5B\%5D).IDataValues}{online documentation}.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Create a Bar Chart
}
\examples{

library(vchartr)

# Classic Bar Chart
vchart(top_generation) \%>\% 
  v_bar(aes(country, electricity_generation))

# Horizontal Bar Chart
vchart(top_generation) \%>\% 
  v_bar(aes(country, electricity_generation), direction = "horizontal")

# Grouped Bar Chart
vchart(subset(world_electricity, type == "total")) \%>\% 
  v_bar(aes(year, generation, fill = source))

# Horizontal Grouped Bar Chart
vchart(subset(world_electricity, type == "total")) \%>\% 
  v_bar(aes(year, generation, fill = source), direction = "horizontal")

# Stacked Bar Chart
vchart(subset(world_electricity, type == "total")) \%>\% 
  v_bar(aes(year, generation, fill = source), stack = TRUE)

# Percentage Stacked Bar Chart
vchart(subset(world_electricity, type == "total")) \%>\% 
  v_bar(aes(year, generation, fill = source), stack = TRUE, percent = TRUE)

}
