% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-jitter-ellipse.R
\name{position_jitterdodge_ellipse}
\alias{position_jitterdodge_ellipse}
\title{Jitter points on an ellipse and dodge groups side-to-side}
\usage{
position_jitterdodge_ellipse(
  jitter.width = NULL,
  jitter.height = NULL,
  dodge.width = 1,
  seed = NA
)
}
\arguments{
\item{jitter.width, jitter.height}{The dimensions of the elliptical field,
from which over-plotted points are sampled.}

\item{dodge.width}{The dodging width, which defaults to 1.}

\item{seed}{A random seed for reproducibility.}
}
\value{
A \code{ggproto} object of class \code{PositionJitterdodgeEllipse}.
}
\description{
This function dodges groups of points side-to-side and adds elliptical random noise
to perfectly over-plotted points. See the position_jitter_ellipse() documentation for more information.
}
\examples{
  library(ggplot2)

  dat <- data.frame(x = rep(1, 500), y = rep(1, 500),
                    group = sample(LETTERS[1:2], 500, replace = TRUE))

  ggplot(dat, aes(x, y, shape = group, color = group)) +
    geom_point(position = position_jitterdodge_ellipse(jitter.width  = 0.5,
                                                       jitter.height =  0.5,
                                                       dodge.width = 1)) +
    coord_cartesian(xlim = c(0, 2), ylim = c(0, 2))

}
\seealso{
Other Functions: 
\code{\link{position_circlepack}()},
\code{\link{position_circlepackdodge}()},
\code{\link{position_jitter_ellipse}()},
\code{\link{position_sunflower}()},
\code{\link{position_sunflowerdodge}()},
\code{\link{sunflower}()}
}
\concept{Functions}
