% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnf-conv.R
\name{nnf_conv2d}
\alias{nnf_conv2d}
\title{Conv2d}
\usage{
nnf_conv2d(
  input,
  weight,
  bias = NULL,
  stride = 1,
  padding = 0,
  dilation = 1,
  groups = 1
)
}
\arguments{
\item{input}{input tensor of shape (minibatch, in_channels, iH , iW)}

\item{weight}{filters of shape (out_channels , in_channels/groups, kH , kW)}

\item{bias}{optional bias tensor of shape (out_channels). Default: \code{NULL}}

\item{stride}{the stride of the convolving kernel. Can be a single number or a
tuple \verb{(sH, sW)}. Default: 1}

\item{padding}{implicit paddings on both sides of the input. Can be a
single number or a tuple \verb{(padH, padW)}. Default: 0}

\item{dilation}{the spacing between kernel elements. Can be a single number or
a tuple \verb{(dH, dW)}. Default: 1}

\item{groups}{split input into groups, \code{in_channels} should be divisible by the
number of groups. Default: 1}
}
\description{
Applies a 2D convolution over an input image composed of several input
planes.
}
