% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-data.R
\name{iterable_dataset}
\alias{iterable_dataset}
\title{Creates an iterable dataset}
\usage{
iterable_dataset(
  name,
  inherit = IterableDataset,
  ...,
  private = NULL,
  active = NULL,
  parent_env = parent.frame()
)
}
\arguments{
\item{name}{a name for the dataset. It it's also used as the class
for it.}

\item{inherit}{you can optionally inherit from a dataset when creating a
new dataset.}

\item{...}{public methods for the dataset class}

\item{private}{passed to \code{\link[R6:R6Class]{R6::R6Class()}}.}

\item{active}{passed to \code{\link[R6:R6Class]{R6::R6Class()}}.}

\item{parent_env}{An environment to use as the parent of newly-created
objects.}
}
\description{
Creates an iterable dataset
}
\examples{
if (torch_is_installed()) {
ids <- iterable_dataset(
  name = "hello",
  initialize = function(n = 5) {
    self$n <- n
    self$i <- 0
  },
  .iter = function() {
    i <- 0
    function() {
      i <<- i + 1
      if (i > self$n) {
        coro::exhausted()
      } else {
        i
      }
    }
  }
)
coro::collect(ids()$.iter())
}
}
