% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbind2.R
\name{rbind2,tinytable,tinytable-method}
\alias{rbind2,tinytable,tinytable-method}
\alias{rbind2}
\title{Combine \code{tinytable} objects by rows (vertically)}
\usage{
\S4method{rbind2}{tinytable,tinytable}(x, y, use_names = TRUE, headers = TRUE, ...)
}
\arguments{
\item{x}{\code{tinytable} object}

\item{y}{\code{tinytable} object}

\item{use_names}{‘TRUE’ binds by matching column name, ‘FALSE’ by position}

\item{headers}{Logical. TRUE inserts the colnames of \code{y} as an extra row between the two tables.}

\item{...}{Additional arguments are ignored.}
}
\description{
Combine \code{tinytable} objects by rows (vertically)
}
\details{
Transformations recorded via \code{format_tt()} and \code{style_tt()} are evaluated at the very end of the rendering pipeline, after \code{rbind2()} has combined the tables. When headers are inserted or columns differ in type, the combined data is first coerced to character, so subsequent formatting/styling works on strings. Apply \code{format_tt()} directly to raw data frames before calling \code{tt()}, or re-run the formatting/styling steps on the combined table to preserve rounding and other rules.

Calls to other \code{tinytable} functions such as \code{style_tt()} or \code{group_tt()} are ignored when applied to \code{x} or \code{y}. These functions should be applied to the final table instead.

Information in these S4 slots is carried over from \code{x} to the combined table:
\itemize{
\item \code{x@output}
\item \code{x@caption}
\item \code{x@width}
}

Information in these S4 slots is concatenated and carried over to the combined table:
\itemize{
\item \code{c(x@notes, y@notes)}
}

This function relies on the \code{rbindlist()} function from the \code{data.table} package.
}
\examples{
library(tinytable)
x <- tt(mtcars[1:3, 1:2], caption = "Combine two tiny tables.")
y <- tt(mtcars[4:5, 8:10])

# rbind() does not support additional aarguments
# rbind2() supports additional arguments

# basic combination
rbind(x, y)

rbind(x, y) |> format_tt(replace = "")

# omit y header
rbind2(x, y, headers = FALSE)

# bind by position rather than column names
rbind2(x, y, use_names = FALSE)

# `iris` example with pre-tt() formatting
dat <- iris[1:3, 1:4]
a <- format_tt(dat, i = 1:3, digits = 1) |> tt()
b <- format_tt(dat, i = 1:3, digits = 2) |> tt()
rbind2(a, b)

}
