% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_html.R
\name{theme_html}
\alias{theme_html}
\title{HTML-specific styles and options}
\usage{
theme_html(
  x,
  engine = get_option("tinytable_html_engine", default = NULL),
  i = NULL,
  j = NULL,
  class = get_option("tinytable_html_class", default = NULL),
  css = get_option("tinytable_html_css", default = NULL),
  css_rule = get_option("tinytable_html_css_rule", default = NULL),
  script = get_option("tinytable_html_script", default = NULL),
  portable = get_option("tinytable_html_portable"),
  tabulator_columns = get_option("tinytable_html_tabulator_columns"),
  tabulator_css_rule = get_option("tinytable_html_tabulator_css_rule"),
  tabulator_layout = get_option("tinytable_html_tabulator_layout", default =
    "fitDataTable"),
  tabulator_options = get_option("tinytable_html_tabulator_options"),
  tabulator_pagination = get_option("tinytable_html_tabulator_pagination"),
  tabulator_search = get_option("tinytable_html_tabulator_search"),
  tabulator_stylesheet = get_option("tinytable_html_tabulator_stylesheet"),
  ...
)
}
\arguments{
\item{x}{A \code{tinytable} object.}

\item{engine}{Character string specifying the HTML engine: "tinytable", "bootstrap", or "tabulator".}

\item{i}{Row indices.}

\item{j}{Column indices.}

\item{class}{String. HTML table class.}

\item{css}{Character vector. CSS style declarations.}

\item{css_rule}{String. CSS rules to customize table styling. Can be one of:
\itemize{
\item Shortcut strings: "tinytable" (default) or "dark" for dark theme
\item A file path to a local CSS file (e.g., "custom.css" or "path/to/styles.css")
\item A URL to an external stylesheet (must start with http/https and end with .css)
\item Inline CSS content as a string
}}

\item{script}{String. Custom JavaScript code or script tags to inject into the HTML output. Useful for loading external JavaScript libraries like Plotly, D3, etc.}

\item{portable}{Logical. Sets whether to create portable HTML output with embedded Javascript, CSS, and base64-encoded images.}

\item{tabulator_columns}{Custom column definitions.}

\item{tabulator_css_rule}{Complete CSS rules.}

\item{tabulator_layout}{Character string. Table layout algorithm for column sizing.
Default is "fitDataTable". Available options: "fitDataTable", "fitData", "fitDataFill",
"fitDataStretch", "fitColumns".}

\item{tabulator_options}{Custom Tabulator.js configuration options.}

\item{tabulator_pagination}{Logical or numeric vector. Pagination settings for large tables.
\itemize{
\item NULL (default): Preserves existing pagination settings, does not change previous configuration
\item FALSE: Explicitly disable pagination
\item TRUE: Enable pagination with automatic page sizes (10, 25, 50, 100, 250) filtered by row count
\item Numeric vector: First element is default page size, full vector provides page size options
}}

\item{tabulator_search}{Character or NULL. Search functionality position.
\itemize{
\item NULL (default): Preserves existing search settings, does not change previous configuration
\item "top": Adds search box above the table
\item "bottom": Adds search box below the table
\item "column": Adds header filters to each column for per-column searching
}}

\item{tabulator_stylesheet}{Character string. CSS stylesheet theme for Tabulator.js tables.
Default is "bootstrap5". Available options: "default", "simple", "midnight", "modern",
"site", "site_dark", "bootstrap3", "bootstrap4", "bootstrap5", "semanticui", "bulma",
"materialize", or a custom HTTP URL starting with "http".}

\item{...}{Additional arguments are ignored.}
}
\description{
HTML-specific styles and options
}
\examples{
\dontrun{
# Load an external JavaScript library
library(tinytable)
x <- tt(mtcars[1:5, 1:5])
x <- theme_html(x, script = '<script src="https://cdn.plot.ly/plotly-2.27.0.min.js"></script>')

# Add custom inline JavaScript
x <- tt(mtcars[1:5, 1:5])
x <- theme_html(x, script = '<script>console.log("Table loaded");</script>')
}

}
