% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poly5_vol.R
\name{poly5_vol}
\alias{poly5_vol}
\title{Estimate the total or partial volume of the tree, based on a 5th degree polynomial function that describes the taper of the tree.}
\usage{
poly5_vol(dbh, h, coef, hi, h0)
}
\arguments{
\item{dbh}{tree diameter at breast height, in centimeters.}

\item{h}{total tree height, in meters.}

\item{coef}{numerical vector containing six coefficients of the 5th degree polynomial function that describes the tree's taper.}

\item{hi}{final height of the tree section whose volume will be calculated, in meters. Default is the total tree height (h).}

\item{h0}{initial height of the tree section whose volume will be calculated, in meters. Default is 0 (ground height).}
}
\value{
a numeric value indicating the total or partial volume of the tree.
}
\description{
Estimates the total or partial volume of the tree from the diameter at breast height, total height, initial section height, final section height and coefficients of the 5th degree polynomial function that describes the tree's taper.
}
\examples{

library(dplyr)
library(minpack.lm)
library(timbeR)

tree_scaling <- tree_scaling \%>\%
mutate(did = di/dbh,
       hih = hi/h)

poli5 <- lm(did~hih+I(hih^2)+I(hih^3)+I(hih^4)+I(hih^5),tree_scaling)

coef_poli <- coef(poli5)

dbh <- 25
h <- 20

poly5_vol(dbh, h, coef_poli)

hi = 15
h0 = .2

poly5_vol(dbh, h, coef_poli, hi, h0)

}
