% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average-treatment-effects-posterior.R
\name{tidy_ate}
\alias{tidy_ate}
\title{Get average treatment effect draws from posterior}
\usage{
tidy_ate(model, treatment, common_support_method, cutoff, ...)
}
\arguments{
\item{model}{A supported Bayesian model fit that can provide fits and predictions.}

\item{treatment}{A character string specifying the name of the treatment variable.}

\item{common_support_method}{Either "sd", or "chisq". Default is unspecified, and no common support calculation is done.}

\item{cutoff}{Cutoff for common support (if in use).}

\item{...}{Arguments to be passed to \code{tidybayes::epred_draws} typically scale for \code{BART} models.}
}
\value{
A tidy data frame (tibble) with treatment effect values.
}
\description{
ATE = Average Treatment Effects
Assumes treated column is either a integer column of 1's (treated) and 0's (nontreated) or logical indicating treatment if TRUE.
}
