% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nested_chclust.R
\docType{data}
\name{stat_nested_hclust}
\alias{stat_nested_hclust}
\alias{StatNestedHclust}
\title{Display a dendrogram as a ggplot2 layer}
\format{
An object of class \code{StatNestedHclust} (inherits from \code{Stat}, \code{ggproto}, \code{gg}) of length 4.
}
\usage{
stat_nested_hclust(
  mapping = NULL,
  data = NULL,
  geom = "segment",
  position = "identity",
  ...,
  inherit.aes = TRUE,
  show.legend = NA
)

StatNestedHclust
}
\arguments{
\item{mapping}{A mapping created using \link[ggplot2:aes]{aes}. Must map x OR y to a qualifier.}

\item{data}{A \link{nested_hclust} object}

\item{geom}{Any geom that takes x, xend, y, and yend. Probably \link[ggplot2:geom_segment]{geom_segment} is
the only one that makes sense.}

\item{position}{Position adjustment}

\item{...}{Passed to the the stat/geom (see \link[ggplot2:geom_segment]{geom_segment})}

\item{inherit.aes}{Inherit aesthetics from ggplot()?}

\item{show.legend}{Show mapped aesthetics in the legend?}
}
\value{
A \link[ggplot2:Stat]{ggplot2::Stat}
}
\description{
Display a dendrogram as a ggplot2 layer
}
\examples{
library(ggplot2)
library(dplyr, warn.conflicts = FALSE)

alta_coniss <- nested_data(
  alta_lake_geochem,
  qualifiers = c(age, depth, zone),
  key = param,
  value = value,
  trans = scale
) \%>\%
  nested_chclust_coniss()

ggplot(alta_coniss) +
  stat_nested_hclust(aes(model = model, y = depth)) +
  scale_y_reverse()

}
\keyword{datasets}
