% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resource.R
\name{resource_get}
\alias{resource_get}
\title{Get Information for a Specific Resource}
\usage{
resource_get(resource, con = NULL)
}
\arguments{
\item{resource}{Character string specifying the resource name.}

\item{con}{An optional database connection. If NULL, a new connection is created
and closed automatically.}
}
\value{
A single-row data frame containing resource information. Stops with
  an error if the resource is not found.
}
\description{
Retrieves detailed information about a single computing resource by name.
}
\details{
The returned data frame contains all resource configuration details needed
for worker deployment, including connection information and resource limits.
}
\examples{
\dontrun{
# Not run:
# Get specific resource
hpc_info <- resource_get("hpc")
print(hpc_info$workers)  # Maximum workers
print(hpc_info$log_folder)  # Log directory
}
}
\seealso{
\code{\link{resource_add}}, \code{\link{resource_list}}
}
