% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pava.R
\name{pava}
\alias{pava}
\alias{isoreg}
\alias{isoregw}
\title{Pooled Adjacent Violators Algorithm}
\usage{
pava(y, x = numeric(0), weights = numeric(0))
}
\arguments{
\item{y}{response variable}

\item{x}{(optional) predictor vector (otherwise y is assumed
to be a priori sorted according to relevant predictor)}

\item{weights}{weights (optional) weights}
}
\value{
List with index (idx) of jump points and values (value)
at each jump point.
}
\description{
Pooled Adjacent Violators Algorithm
}
\examples{
x <- runif(5e3, -5, 5)
pr <- lava::expit(-1 + x)
y <- rbinom(length(pr), 1, pr)
pv <- pava(y, x)
plot(pr ~ x, cex=0.3)
with(pv, lines(sort(x)[index], value, col="red", type="s"))
}
\author{
Klaus K. Holst
}
