% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_data_functions.R
\name{merge_columns}
\alias{merge_columns}
\title{Bind two or more data frames with different columns}
\usage{
merge_columns(x, y)
}
\arguments{
\item{x}{Either a data.frame or a list of data.frames.}

\item{y}{A data.frame, optional if x is a list.}
}
\value{
Returns a single data.frame with all the input data frames merged.
}
\description{
Takes two or more data.frames with different column names or different column orders and binds them to a single data.frame.
}
\examples{
df_1 <-  data.frame(
  title = c(
    "EviAtlas: a tool for visualising evidence synthesis databases",
    "revtools: An R package to support article screening for evidence synthesis"
  ),
  year = c("2019", "2019")
)

df_2 <-  data.frame(
  title = c(
    "An automated approach to identifying search terms for systematic reviews",
    "Reproducible, flexible and high-throughput data extraction from primary literature"
  ),
  authors = c("Grames et al", "Pick et al")
)

merge_columns(df_1, df_2)
}
