% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidenceScores.R
\name{calcPerCellMappingMetric}
\alias{calcPerCellMappingMetric}
\title{Per-cell Confidence Score:
Calculates the weighted Mahalanobis distance for the query cells to reference clusters. Returns a vector
of distance scores, one per query cell. Higher distance metric indicates less confidence.}
\usage{
calcPerCellMappingMetric(
  reference,
  query,
  Z_orig = TRUE,
  metric = "mahalanobis"
)
}
\arguments{
\item{reference}{Reference object as returned by Symphony buildReference()}

\item{query}{Query object as returned by Symphony mapQuery()}

\item{Z_orig}{Define reference distribution using original PCA embedding or harmonized PC embedding}

\item{metric}{Uses Mahalanobis by default, but added as a parameter for potential future use}
}
\value{
A vector of per-cell mapping metric scores for each cell.
}
\description{
Per-cell Confidence Score:
Calculates the weighted Mahalanobis distance for the query cells to reference clusters. Returns a vector
of distance scores, one per query cell. Higher distance metric indicates less confidence.
}
