% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oin.R
\name{as.oin}
\alias{as.oin}
\title{Parse organizational identity numbers}
\usage{
as.oin(oin)
}
\arguments{
\item{oin}{Vector with swedish organizational identity numbers in character format. See details.}
}
\value{
Character vector (of class \code{oin} and \code{AsIs}) with swedish organizational identity numbers.
}
\description{
Check and convert a vector of organizational identity numbers.
}
\details{
The following format is accepted: 
\itemize{
  \item character: \code{GNNNNN-NNNC}
}
}
\examples{
ex_oin <- c("556000-4615", "232100-0156", "802002-4280", "8020024280", "AA2002-4280")
as.oin(ex_oin)

}
\references{
\href{https://www.riksdagen.se/sv/dokument-och-lagar/dokument/svensk-forfattningssamling/lag-1974174-om-identitetsbeteckning-for_sfs-1974-174/}{Lag (1974:174) om identitetsbeteckning for juridiska personer m.fl.}
}
