% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.survdnn.R
\name{summary.survdnn}
\alias{summary.survdnn}
\title{Summarize a Deep Survival Neural Network Model}
\usage{
\method{summary}{survdnn}(object, ...)
}
\arguments{
\item{object}{An object of class `"survdnn"` returned by the [survdnn()] function.}

\item{...}{Currently ignored (for future compatibility).}
}
\value{
Invisibly returns an object of class `"summary.survdnn"`.
}
\description{
Provides a structured summary of a fitted `survdnn` model, including the network architecture,
training configuration, and data characteristics. The summary is printed automatically with
a styled header and sectioned output using \{cli\} and base formatting. The object is returned invisibly.
}
\examples{
\donttest{
set.seed(42)
sim_data <- data.frame(
  age = rnorm(100, 60, 10),
  sex = factor(sample(c("male", "female"), 100, TRUE)),
  trt = factor(sample(c("A", "B"), 100, TRUE)),
  time = rexp(100, 0.05),
  status = rbinom(100, 1, 0.7)
)
mod <- survdnn(Surv(time, status) ~ age + sex + trt, data = sim_data, epochs = 50, verbose = FALSE)
summary(mod)
}
}
