% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_risk_score.R
\name{calc_risk_score}
\alias{calc_risk_score}
\title{Compute risk scores from a fitted survival model}
\usage{
calc_risk_score(model, data = NULL, type = "lp", ...)
}
\arguments{
\item{model}{A fitted \code{coxph} object.}

\item{data}{Optional dataset on which to score the model. Defaults to the
training data stored within \code{model}.}

\item{type}{Scale of the predictions to return. Either \code{"lp"} (linear
predictor, the default) or \code{"risk"}. If \code{NULL} or omitted, \code{"lp"} is used.}

\item{...}{Additional arguments passed to \code{\link[stats:predict]{stats::predict()}}.}
}
\value{
A numeric vector containing the requested risk scores.
}
\description{
This helper wraps \code{stats::predict()} for \code{coxph} objects so that package users
can easily obtain linear predictors (default) or risk scores to feed into
downstream metrics such as time-dependent ROC or Harrell's C-index.
}
\examples{
if (requireNamespace("survival", quietly = TRUE)) {
  fit <- survival::coxph(survival::Surv(time, status) ~ age, data = survival::lung)
  # Linear predictor on the training data
  calc_risk_score(fit)

  # Risk scale predictions on new data
  calc_risk_score(fit, survival::lung, type = "risk")
}
}
