% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stcov.R
\name{haff_cov}
\alias{haff_cov}
\title{Stein/Haff's covariance estimator}
\usage{
haff_cov(S, n)
}
\arguments{
\item{S}{Sample covariance matrix}

\item{n}{Number of observations}
}
\value{
Estimated covariance matrix
}
\description{
Stein/Haff's covariance estimator
}
\examples{
p <- 5
n <- 10
S <- rWishart(1, n, diag(p))[,,1]
haff_cov(S, n)
}
\references{
Haff, L. R. "The Variational Form of Certain Bayes Estimators." The Annals
  of Statistics 19, no. 3 (1991): 1163-1190.

Lin, S.P. and Perlman, M.D.. "A Monte Carlo comparison of four
  estimators of a covariance matrix." Multivariate Analysis 6 (1985): 411-429.

Stein, C. "Estimation of a covariance matrix". Rietz Lecture (1975).
}

