% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordinal_pattern_distribution.R
\name{ordinal_pattern_distribution}
\alias{ordinal_pattern_distribution}
\title{A function to compute ordinal pattern statistics}
\usage{
ordinal_pattern_distribution(x, ndemb)
}
\arguments{
\item{x}{A numeric vector (e.g. a time series), from which the ordinal pattern distribution is to be calculated}

\item{ndemb}{Embedding dimension of the ordinal patterns (i.e. sliding window size). Should be chosen such as length(x) >> ndemb}
}
\value{
A character vector of length factorial(ndemb) is returned.
}
\description{
Computation of the ordinal patterns of a time series (see e.g. Bandt and Pompe 2002)
}
\details{
This function returns the distribution of ordinal patterns using the Keller coding scheme, detailed in Physica A 356 (2005) 114-120. NA values are allowed, and any pattern that contains at least one NA value will be ignored.
(Fast) C routines are used for computing ordinal patterns.
}
\examples{
x = arima.sim(model=list(ar = 0.3), n = 10^4)
ordinal_pattern_distribution(x = x, ndemb = 6)
}
\references{
Bandt, C. and Pompe, B., 2002. Permutation entropy: a natural complexity measure for time series. Physical review letters, 88(17), p.174102.
}
\author{
Sebastian Sippel
}
