% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{slp}
\alias{slp}
\title{Standard Load Profile Data for Electricity from BDEW}
\format{
A data.frame with 9,504 observations and 5 variables:
\describe{
\item{profile_id}{character, identifier for load profile, see 'Details'}
\item{period}{character, one of 'summer', 'winter', 'transition'}
\item{day}{character, one of 'saturday', 'sunday', 'workday'}
\item{timestamp}{character, format: \%H:\%M}
\item{watt}{numeric, electric power}
}
}
\source{
\url{https://www.bdew.de/energie/standardlastprofile-strom/}

\url{https://www.bdew.de/media/documents/Profile.zip}

\url{https://www.bdew.de/media/documents/1999_Repraesentative-VDEW-Lastprofile.pdf}
}
\usage{
slp
}
\description{
Data about representative, standard load profiles for electricity from
the German Association of Energy and Water Industries (BDEW Bundesverband
der Energie- und Wasserwirtschaft e.V.) in a tidy format.
}
\details{
There are 96 x 1/4h measurements of electrical power for each combination
of \code{profile_id}, \code{period} and \code{day}, which we refer to as the "standard load
profile". This dataset results from an analysis of 1,209 load profiles of
low-voltage electricity consumers in Germany, published in 1999.

In total there are 11 \code{profile_id} for three different customer groups:
\itemize{
\item Households: \code{H0}
\item Commercial: \code{G0}, \code{G1}, \code{G2}, \code{G3}, \code{G4}, \code{G5}, \code{G6}
\item Agriculture: \code{L0}, \code{L1}, \code{L2}
}

Call \code{\link[=slp_info]{slp_info()}} to for more information and examples.

Period definitions:
\itemize{
\item \code{summer}: May 15 to September 14
\item \code{winter}: November 1 to March 20
\item \code{transition}: March 21 to May 14, and September 15 to October 31
}

Day definitions:
\itemize{
\item \code{workday}: Monday to Friday
\item \code{saturday}: Saturdays; Dec 24th and Dec 31th are considered a Saturdays too
if they are not a Sunday
\item \code{sunday}: Sundays and all public holidays
}
}
\examples{
head(slp)

}
\keyword{datasets}
