% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tospongebob.R
\name{tospongebob.data.frame}
\alias{tospongebob.data.frame}
\title{SpongeBob-Case Conversion for Data Frames}
\usage{
\method{tospongebob}{data.frame}(x, ..., convert.rownames = TRUE,
  convert.colnames = TRUE)
}
\arguments{
\item{x}{data.frame with text to be converted to Mocking SpongeBob case.}

\item{...}{onlY hERe tO sATisFy R CMd CHeCk.}

\item{convert.rownames}{logical, indicating whether or not to convert the
row names of the data.frame}

\item{convert.colnames}{logical, indicating whether or not to convert the
column names of the data.frame}
}
\value{
data.frame with its text converted to Mocking SpongeBob case.
}
\description{
Convert data.frame objects to
\href{https://knowyourmeme.com/memes/mocking-spongebob}{Mocking SpongeBob
case}. This is the S3 method for data.frame objects. Generally, you will not
be using this method directly; instead, use the S3 generic
\code{\link{tospongebob}}. If you really need to use this method, you will
need to do \code{spongebob:::tospongebob.data.frame} because it is an
internal method.

This method will convert character and factor columns to Mocking SpongeBob
case. It will also optionlly convert column and row names, enabled by
default.
}
\examples{
df1 <- head(datasets::CO2)
tospongebob(df1)

df2 <- head(datasets::mtcars)
tospongebob(df2)
}
\seealso{
\code{\link{tospongebob}}
}
