% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LocalSparse.R
\name{lans}
\alias{lans}
\title{Local Adaptive Network Sparsification}
\usage{
lans(network, alpha, output, directed = FALSE)
}
\arguments{
\item{network}{Weighted adjacency matrix, weighted \code{igraph} network, or edge list formatted | n1 | n2 | weight | with colnames \code{c("n1", "n2", "weight")}.}

\item{alpha}{The \code{alpha} value is a predetermined threshold to designate statistically important edges by their fractional edge weight at each node. If the probability of choosing that edge via the CDF is less than or equal to \code{alpha}, then the edge is not included.}

\item{output}{If the output should be directed or undirected. Default is that the output is the same as the input based on adjacency matrix symmetry. If the default is overridden, set as either "undirected" or "directed".}

\item{directed}{If \code{TRUE}, specifies that the inputted network is directed. Default is \code{FALSE}.}
}
\value{
Weighted adjacency matrix of sparsified network.
}
\description{
Remove all edges under certain probability of the fractional edge weight, \code{alpha}.
}
\details{
For more information on finding alpha values, see: https://journals.plos.org/plosone/article?id=10.1371/journal.pone.0016431#s5
}
\examples{
#Generate random ER graph with uniformly random edge weights
g = igraph::erdos.renyi.game(100, 0.1)
igraph::E(g)$weight <- runif(length(igraph::E(g)))
#Sparsify g via LANS
S = lans(g, alpha = 0.3, output = "undirected", directed = FALSE)
#Convert sparsifier to edge list
S_List = simplifyNet::Mtrx_EList(S, directed = FALSE)
sg = simplifyNet::net.as(S_List, net.to="igraph", directed=FALSE)
igraph::ecount(sg)/igraph::ecount(g)#fraction of edges in the sparsifier
}
\references{
Foti, N. J., Hughes, J. M., & Rockmore, D. N. (2011). Nonparametric sparsification of complex multiscale networks. PloS one, 6(2), e16431.
}
\author{
Andrew Kramer

Alexander Mercier
}
