% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/laplace_matrix.R
\name{laplacian_matrix_signed}
\alias{laplacian_matrix_signed}
\title{Signed Graph Laplacian}
\usage{
laplacian_matrix_signed(g, norm = FALSE, sparse = FALSE)
}
\arguments{
\item{g}{igraph object with a sign edge attribute.}

\item{norm}{Whether to calculate the normalized Laplacian. See definitions below.}

\item{sparse}{Logical scalar, whether to return the result as a sparse matrix. The Matrix package is required for sparse matrices.}
}
\value{
a numeric matrix
}
\description{
The Laplacian of a signed graph.
}
\details{
See \link[igraph]{laplacian_matrix} of igraph for more details. In the signed case, D is a diagonal matrix containing the absolute values of row sums of the signed adjacency matrix.
}
\examples{
library(igraph)
g <- sample_islands_signed(3, 10, 5 / 10, 1)
laplacian_matrix_signed(g)
laplacian_matrix_signed(g, norm = TRUE)
}
\author{
David Schoch
}
