% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_proxies.R
\name{sg_add_node_p}
\alias{sg_add_node_p}
\alias{sg_add_edge_p}
\title{Add node or edge}
\usage{
sg_add_node_p(proxy, data, ..., refresh = TRUE)

sg_add_edge_p(proxy, data, ..., refresh = TRUE)
}
\arguments{
\item{proxy}{An object of class \code{sigmajsProxy} as returned by \code{\link{sigmajsProxy}}.}

\item{data}{A \code{data.frame} of _one_ node or edge.}

\item{...}{any column.}

\item{refresh}{Whether to refresh the graph after node is dropped, required to take effect, if you are running force the algorithm is killed.}
}
\value{
The \code{proxy} object.
}
\description{
Proxies to dynamically add a node or an edge to an already existing graph.
}
\note{
Have the parameters from your initial graph match that of the node you add, i.e.: if you pass \code{size} in your initial chart,
make sure you also have it in your proxy.
}
\examples{
\dontrun{
demo("add-node", package = "sigmajs")
demo("add-edge", package = "sigmajs")
demo("add-node-edge", package = "sigmajs")
}

}
