% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots_time_series.R
\name{plot_time_series}
\alias{plot_time_series}
\title{Time series plots}
\usage{
plot_time_series(
  df,
  settings = settings,
  n_col = 3,
  n_sep = 5,
  highlighted_area = NULL,
  plot_start = NULL,
  plot_end = NULL,
  file_path = NULL,
  title = TRUE,
  save = TRUE,
  device = "jpg",
  width = 10,
  height = 3,
  units = "in"
)
}
\arguments{
\item{settings}{list with model setting, in the format returned by the
function \code{initialize_settings}}

\item{n_col}{number of columns for grid plots}

\item{n_sep}{increments of x axis ticks in years}

\item{highlighted_area}{data frame with two columns called \code{start} and
\code{end} containing start and end date, e.g. \code{1990.25} and
\code{1992.75} for 1990 Q2 until 1992 Q4
(only used if \code{plot_type = "timeseries"})}

\item{plot_start}{start of x axis in years, e.g., \code{1990.5} (only used if
\code{plot_type = "timeseries"})}

\item{plot_end}{end of x axis in years, e.g., \code{2010.25} (only used if
\code{plot_type = "timeseries"})}

\item{file_path}{file path for plots}

\item{title}{boolean indicating if plots should contain titles}

\item{save}{boolean indicating if plots should be saved, if \code{FALSE}, the
plots will be printed instead, default is \code{save = FALSE} (ignored if
\code{file_path} is provided)}

\item{device}{character string with format used in \code{ggsave}}

\item{width}{plot width in \code{units}, for grid plots adjusted for the
number of plot columns \code{n_col}}

\item{height}{plot height in \code{units}, for grid plots adjusted for the
number of plot rows implied by \code{n_col}}

\item{units}{units for plot size (\code{"in", "cm", "mm", or "px"})}
}
\value{
nothing
}
\description{
Creates a set of time series plots of the results.
}
\keyword{internal}
