% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solvers.R
\name{solvers}
\alias{solvers}
\title{Check or translate between deSolve and Julia DifferentialEquations solvers}
\usage{
solvers(method, from = c("R", "Julia"), to = NULL, show_info = FALSE)
}
\arguments{
\item{method}{Character string of solver name}

\item{from}{Character string indicating source language: "R" or "Julia"}

\item{to}{Character string indicating target language: "R" or "Julia"}

\item{show_info}{Logical, whether to display additional solver information}
}
\value{
Character vector of equivalent solver(s) or list with details
}
\description{
This function either checks whether a solver method exists or provides
bidirectional translation between R's deSolve package solvers and Julia's
DifferentialEquations.jl solvers.
}
\examples{
# Translate from R to Julia
solvers("euler", from = "R", to = "Julia")
solvers("rk45dp6", from = "R", to = "Julia")

# Translate from Julia to R
solvers("Tsit5", from = "Julia", to = "R")
solvers("DP5", from = "Julia", to = "R", show_info = TRUE)

# List all available solvers
solvers(from = "R")
solvers(from = "Julia")
}
\concept{simulate}
