% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_func.R
\name{rem}
\alias{rem}
\alias{mod}
\alias{\%REM\%}
\title{Remainder and modulus}
\usage{
rem(a, b)

mod(a, b)

a \%REM\% b
}
\arguments{
\item{a}{Dividend}

\item{b}{Divisor}
}
\value{
Remainder
}
\description{
Remainder and modulus operators. The modulus and remainder are not the same in case either a or b is negative. If you work with negative numbers, modulus is always non-negative (it matches the sign of the divisor).
}
\examples{
# Modulus and remainder are the same when a and b are positive
a <- 7
b <- 3
rem(a, b)
mod(a, b)
# Modulus and remainder are NOT when either a or b is negative
a <- -7
b <- 3
rem(a, b)
mod(a, b)
a <- 7
b <- -3
rem(a, b)
mod(a, b)
# Modulus and remainder are the same when both a and b are negative
a <- -7
b <- -3
rem(a, b)
mod(a, b)

# Alternative way of computing the remainder:
a \%REM\% b
}
\concept{custom}
