% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ploidy_inference.R
\name{ploidy.inference}
\alias{ploidy.inference}
\title{Ploidy inference with quantogram}
\usage{
ploidy.inference(
  x,
  chrom = NULL,
  start = NULL,
  end = NULL,
  penalty = 25,
  do_segmentation = TRUE,
  seg_length = NULL,
  iod = NULL,
  mean_bincount = NULL
)
}
\arguments{
\item{x}{Bincounts or segment means}

\item{chrom}{Optional chromosome numbers}

\item{start}{Optional bin/segment start positions}

\item{end}{Optional bin/segment end positions}

\item{penalty}{If segmenting, penalty parameter for the fused lasso (higher penalty, fewer segments)}

\item{do_segmentation}{Boolean, whether to do segmentation (set this to TRUE if giving unsegmented bincounts)}

\item{seg_length}{If giving already segmented data, length of each segment}

\item{iod}{If giving already segmented data, the index of dispersion of the bincount distribution (that is, within segments, not including between-segment variance)}

\item{mean_bincount}{If giving already segmented ratio values, the original mean bincount}
}
\value{
A ploidy inference object

\describe{
  \item{penalty}{The segmentation penalty given as an argument, if any}
  \item{multiply_ratios_by}{To convert ratios to (unrounded) copy number estimates, multiply by this number}
  \item{subtract_from_scaled_ratios}{To convert ratios to (unrounded) copy numbers, after multiplying, subtract this number. Only required if the count data have some extra reads even at copy number 0, generally due to mapping problems}
  \item{ploidy}{The estimated ploidy}
  \item{peak_height}{The height of the quantogram peak at the estimated ploidy. Between 0 and 1. Higher values indicate a stronger signal}
  \item{segmentation}{The segmented values (either given as an argument, or produced interally by segmentation)}
  \item{polar_quantogram}{The complex-valued quantogram, whose absolute values measure consistency with each possible ploidy}
  \item{bincounts}{The raw bincounts given as an argument (if a segmentation was not given directly)}
  \item{theoretical_quantogram}{Based on the inferred copy numbers and index of dispersion, what the absolute value of the quantogram should look like. Deviation of this theoretical quantogram from the real one indicate that the ploidy estimate may be wrong}
  \item{theoretical_peak_height}{Height of the peak in the theoretical quantogram, measuring the expected strength of signal for the ploidy value}
  \item{confidence_ratio}{Ratio of actual to theoretical peak height. Values near (or above) 1 indicate the signal was as strong as would be expected gievn this data quality and ploidy; low values indicate that the ploidy inference may be wrong or that there are unexpected quality issues with the data}
}
}
\description{
Infer ploidy of a cell, given a copy number profile.
Constructs a quantogram (either modular or cosine, depending on parameters).
The maximum of the quantogram is the estimated ploidy.
If unsegmented bincounts are given, segmentation will be performed using the
fused lasso.
}
\examples{
# Generating a random copy number profile
set.seed(705)
cns <- rpois(30, 3) + 1
x <- unlist(lapply(cns, function(cn) rpois(100, 25 * cn)))
annotations <- data.frame(chrom = 1, start = 1:length(x), end = 1:length(x))

# Inferring ploidy
# Annotations and penalty are optional
estimate.from.bincounts <- ploidy.inference(x, annotations$chrom, annotations$start, penalty = 25)

# Using scquantum internal functions to segment the data and estimate index
# of git@github.com:navinlabcode/scquantum.git
# dispersion
mu.est <- mean(x)
iod.est <- timeseries.iod(x)
seg <- prof2invals(x, 25, annotations, "chrom", "start", "end")
mean.est <- mean(x)
iod.est <- timeseries.iod(x)
estimate.from.segmentation <-
  ploidy.inference(
    seg$mean,
    seg$chrom,
    seg$start,
    seg$end,
    iod = iod.est,
    mean_bincount = mean.est,
    do_segmentation = FALSE
  )
}
